/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.io.File;
import java.net.URI;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class LateConfigTest {
    private static final String CONFIG = "target/test-classes/log4j-test1.xml";
    private static LoggerContext context;

    @BeforeAll
    public static void setupClass() {
        context = LoggerContext.getContext((boolean)false);
    }

    @AfterAll
    public static void tearDownClass() {
        Configurator.shutdown((LoggerContext)context);
        StatusLogger.getLogger().reset();
    }

    @Test
    public void testReconfiguration() throws Exception {
        Configuration cfg = context.getConfiguration();
        Assertions.assertNotNull((Object)cfg, (String)"No configuration");
        Assertions.assertTrue((boolean)(cfg instanceof DefaultConfiguration), (String)"Not set to default configuration");
        File file = new File(CONFIG);
        LoggerContext loggerContext = LoggerContext.getContext(null, (boolean)false, (URI)file.toURI());
        Assertions.assertNotNull((Object)loggerContext, (String)"No Logger Context");
        Configuration newConfig = loggerContext.getConfiguration();
        Assertions.assertNotSame((Object)cfg, (Object)newConfig, (String)"Configuration not reset");
        Assertions.assertTrue((boolean)(newConfig instanceof XmlConfiguration), (String)"Reconfiguration failed");
        context = LoggerContext.getContext((boolean)false);
        Configuration sameConfig = context.getConfiguration();
        Assertions.assertSame((Object)newConfig, (Object)sameConfig, (String)"Configuration should not have been reset");
    }
}

