/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.appender;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.SerializedLayout;
import org.apache.logging.log4j.test.appender.ListAppender;

public class EncodingListAppender
extends ListAppender {
    public EncodingListAppender(String name) {
        super(name);
    }

    public EncodingListAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean newline, boolean raw) {
        super(name, filter, layout, newline, raw);
    }

    @Override
    public synchronized void append(LogEvent event) {
        Layout layout = this.getLayout();
        if (layout == null) {
            this.events.add(event);
        } else if (layout instanceof SerializedLayout) {
            Destination content = new Destination();
            content.byteBuffer.put(layout.getHeader());
            layout.encode((Object)event, (ByteBufferDestination)content);
            content.getByteBuffer().flip();
            byte[] record = new byte[content.getByteBuffer().remaining()];
            content.getByteBuffer().get(record);
            this.data.add(record);
        } else {
            Destination content = new Destination();
            layout.encode((Object)event, (ByteBufferDestination)content);
            content.getByteBuffer().flip();
            byte[] record = new byte[content.getByteBuffer().remaining()];
            content.getByteBuffer().get(record);
            this.write(record);
        }
    }

    private static class Destination
    implements ByteBufferDestination {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[8192]);

        private Destination() {
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        public ByteBuffer drain(ByteBuffer buf) {
            throw new IllegalStateException("Unexpected message larger than 4096 bytes");
        }

        public void writeBytes(ByteBuffer data) {
            this.byteBuffer.put(data);
        }

        public void writeBytes(byte[] data, int offset, int length) {
            this.byteBuffer.put(data, offset, length);
        }
    }
}

