/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.junit;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.LoggerContextAccessor;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.ReconfigurationPolicy;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.support.TypeBasedParameterResolver;

class LoggerContextResolver
extends TypeBasedParameterResolver<LoggerContext>
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    LoggerContextResolver() {
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        Class testClass = context.getRequiredTestClass();
        LoggerContextSource testSource = testClass.getAnnotation(LoggerContextSource.class);
        if (testSource != null) {
            LoggerContextConfig config = new LoggerContextConfig(testSource, context);
            LoggerContextResolver.getTestClassStore(context).put(LoggerContext.class, (Object)config);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        LoggerContextConfig config = (LoggerContextConfig)LoggerContextResolver.getTestClassStore(context).get(LoggerContext.class, LoggerContextConfig.class);
        if (config != null) {
            config.close();
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        LoggerContextSource source;
        Class testClass = context.getRequiredTestClass();
        if (testClass.isAnnotationPresent(LoggerContextSource.class)) {
            LoggerContextConfig config = (LoggerContextConfig)LoggerContextResolver.getTestClassStore(context).get(LoggerContext.class, LoggerContextConfig.class);
            if (config == null) {
                throw new IllegalStateException("Specified @LoggerContextSource but no LoggerContext found for test class " + testClass.getCanonicalName());
            }
            if (config.reconfigurationPolicy == ReconfigurationPolicy.BEFORE_EACH) {
                config.reconfigure();
            }
        }
        if ((source = context.getRequiredTestMethod().getAnnotation(LoggerContextSource.class)) != null) {
            LoggerContextConfig config = new LoggerContextConfig(source, context);
            if (config.reconfigurationPolicy == ReconfigurationPolicy.BEFORE_EACH) {
                config.reconfigure();
            }
            LoggerContextResolver.getTestInstanceStore(context).put(LoggerContext.class, (Object)config);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Class testClass;
        LoggerContextConfig testInstanceConfig = (LoggerContextConfig)LoggerContextResolver.getTestInstanceStore(context).get(LoggerContext.class, LoggerContextConfig.class);
        if (testInstanceConfig != null) {
            testInstanceConfig.close();
        }
        if ((testClass = context.getRequiredTestClass()).isAnnotationPresent(LoggerContextSource.class)) {
            LoggerContextConfig config = (LoggerContextConfig)LoggerContextResolver.getTestClassStore(context).get(LoggerContext.class, LoggerContextConfig.class);
            if (config == null) {
                throw new IllegalStateException("Specified @LoggerContextSource but no LoggerContext found for test class " + testClass.getCanonicalName());
            }
            if (config.reconfigurationPolicy == ReconfigurationPolicy.AFTER_EACH) {
                config.reconfigure();
            }
        }
    }

    public LoggerContext resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return LoggerContextResolver.getParameterLoggerContext(parameterContext, extensionContext);
    }

    private static ExtensionContext.Store getTestClassStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{LoggerContext.class, context.getRequiredTestClass()}));
    }

    private static ExtensionContext.Store getTestInstanceStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{LoggerContext.class, context.getRequiredTestInstance()}));
    }

    static LoggerContext getParameterLoggerContext(ParameterContext parameterContext, ExtensionContext extensionContext) {
        if (parameterContext.getDeclaringExecutable() instanceof Method) {
            LoggerContextAccessor accessor = (LoggerContextAccessor)LoggerContextResolver.getTestInstanceStore(extensionContext).get(LoggerContext.class, LoggerContextAccessor.class);
            return accessor != null ? accessor.getLoggerContext() : ((LoggerContextAccessor)LoggerContextResolver.getTestClassStore(extensionContext).get(LoggerContext.class, LoggerContextAccessor.class)).getLoggerContext();
        }
        return ((LoggerContextAccessor)LoggerContextResolver.getTestClassStore(extensionContext).get(LoggerContext.class, LoggerContextAccessor.class)).getLoggerContext();
    }

    private static class LoggerContextConfig
    implements AutoCloseable,
    LoggerContextAccessor {
        private final LoggerContext context;
        private final ReconfigurationPolicy reconfigurationPolicy;
        private final long shutdownTimeout;
        private final TimeUnit unit;

        private LoggerContextConfig(LoggerContextSource source, ExtensionContext extensionContext) {
            String displayName = extensionContext.getDisplayName();
            ClassLoader classLoader = extensionContext.getRequiredTestClass().getClassLoader();
            this.context = Configurator.initialize((String)displayName, (ClassLoader)classLoader, (String)source.value());
            this.reconfigurationPolicy = source.reconfigure();
            this.shutdownTimeout = source.timeout();
            this.unit = source.unit();
        }

        public LoggerContext getLoggerContext() {
            return this.context;
        }

        public void reconfigure() {
            this.context.reconfigure();
        }

        @Override
        public void close() {
            this.context.stop(this.shutdownTimeout, this.unit);
        }
    }
}

