/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.datetime;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.core.util.datetime.FastDateParser;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FastDateParserSDFTest {
    private final String format;
    private final String input;
    private final Locale locale;
    private final boolean valid;
    private final TimeZone timeZone = TimeZone.getDefault();

    @Parameterized.Parameters(name="{index}: {0} {1} {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"z yyyy", "GMT 2010", Locale.UK, true}, {"z yyyy", "GMT-123 2010", Locale.UK, false}, {"z yyyy", "GMT-1234 2010", Locale.UK, false}, {"z yyyy", "GMT-12:34 2010", Locale.UK, true}, {"z yyyy", "GMT-1:23 2010", Locale.UK, true}, {"z yyyy", "-1234 2010", Locale.UK, true}, {"z yyyy", "-12:34 2010", Locale.UK, false}, {"z yyyy", "-123 2010", Locale.UK, false}, {"MM/dd/yyyy", "01/11/12", Locale.UK, true}, {"MM/dd/yy", "01/11/12", Locale.UK, true}, {"HH", "00", Locale.UK, true}, {"KK", "00", Locale.UK, true}, {"hh", "00", Locale.UK, true}, {"kk", "00", Locale.UK, true}, {"HH", "01", Locale.UK, true}, {"KK", "01", Locale.UK, true}, {"hh", "01", Locale.UK, true}, {"kk", "01", Locale.UK, true}, {"HH", "11", Locale.UK, true}, {"KK", "11", Locale.UK, true}, {"hh", "11", Locale.UK, true}, {"kk", "11", Locale.UK, true}, {"HH", "12", Locale.UK, true}, {"KK", "12", Locale.UK, true}, {"hh", "12", Locale.UK, true}, {"kk", "12", Locale.UK, true}, {"HH", "13", Locale.UK, true}, {"KK", "13", Locale.UK, true}, {"hh", "13", Locale.UK, true}, {"kk", "13", Locale.UK, true}, {"HH", "23", Locale.UK, true}, {"KK", "23", Locale.UK, true}, {"hh", "23", Locale.UK, true}, {"kk", "23", Locale.UK, true}, {"HH", "24", Locale.UK, true}, {"KK", "24", Locale.UK, true}, {"hh", "24", Locale.UK, true}, {"kk", "24", Locale.UK, true}, {"HH", "25", Locale.UK, true}, {"KK", "25", Locale.UK, true}, {"hh", "25", Locale.UK, true}, {"kk", "25", Locale.UK, true}, {"HH", "48", Locale.UK, true}, {"KK", "48", Locale.UK, true}, {"hh", "48", Locale.UK, true}, {"kk", "48", Locale.UK, true});
    }

    public FastDateParserSDFTest(String format, String input, Locale locale, boolean valid) {
        this.format = format;
        this.input = input;
        this.locale = locale;
        this.valid = valid;
    }

    private void checkParse(String formattedDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.format, this.locale);
        sdf.setTimeZone(this.timeZone);
        FastDateParser fdf = new FastDateParser(this.format, this.timeZone, this.locale);
        Date expectedTime = null;
        Class<?> sdfE = null;
        try {
            expectedTime = sdf.parse(formattedDate);
            if (!this.valid) {
                throw new RuntimeException("Test data error: expected SDF parse to fail, but got " + expectedTime);
            }
        }
        catch (ParseException e) {
            if (this.valid) {
                throw new RuntimeException("Test data error: expected SDF parse to succeed, but got " + e);
            }
            sdfE = e.getClass();
        }
        Date actualTime = null;
        Class<?> fdfE = null;
        try {
            actualTime = fdf.parse(formattedDate);
            if (!this.valid) {
                Assert.fail((String)("Expected FDP parse to fail, but got " + actualTime));
            }
        }
        catch (ParseException e) {
            if (this.valid) {
                Assert.fail((String)("Expected FDP parse to succeed, but got " + e));
            }
            fdfE = e.getClass();
        }
        if (this.valid) {
            Assert.assertEquals((String)(this.locale.toString() + " " + formattedDate + "\n"), (Object)expectedTime, (Object)actualTime);
        } else {
            Assert.assertEquals((String)(this.locale.toString() + " " + formattedDate + " expected same Exception "), sdfE, fdfE);
        }
    }

    private void checkParsePosition(String formattedDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.format, this.locale);
        sdf.setTimeZone(this.timeZone);
        FastDateParser fdf = new FastDateParser(this.format, this.timeZone, this.locale);
        ParsePosition sdfP = new ParsePosition(0);
        Date expectedTime = sdf.parse(formattedDate, sdfP);
        int sdferrorIndex = sdfP.getErrorIndex();
        if (this.valid) {
            Assert.assertEquals((String)"Expected SDF error index -1 ", (long)-1L, (long)sdferrorIndex);
            int endIndex = sdfP.getIndex();
            int length = formattedDate.length();
            if (endIndex != length) {
                throw new RuntimeException("Test data error: expected SDF parse to consume entire string; endindex " + endIndex + " != " + length);
            }
        } else {
            int errorIndex = sdfP.getErrorIndex();
            if (errorIndex == -1) {
                throw new RuntimeException("Test data error: expected SDF parse to fail, but got " + expectedTime);
            }
        }
        ParsePosition fdfP = new ParsePosition(0);
        Date actualTime = fdf.parse(formattedDate, fdfP);
        int fdferrorIndex = fdfP.getErrorIndex();
        if (this.valid) {
            Assert.assertEquals((String)"Expected FDF error index -1 ", (long)-1L, (long)fdferrorIndex);
            int endIndex = fdfP.getIndex();
            int length = formattedDate.length();
            Assert.assertEquals((String)("Expected FDF to parse full string " + fdfP), (long)length, (long)endIndex);
            Assert.assertEquals((String)(this.locale.toString() + " " + formattedDate + "\n"), (Object)expectedTime, (Object)actualTime);
        } else {
            Assert.assertNotEquals((String)("Test data error: expected FDF parse to fail, but got " + actualTime), (long)-1L, (long)fdferrorIndex);
            Assert.assertTrue((String)("FDF error index (" + fdferrorIndex + ") should approxiamate SDF index (" + sdferrorIndex + ")"), (sdferrorIndex - fdferrorIndex <= 4 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLowerCase() throws Exception {
        this.checkParse(this.input.toLowerCase(this.locale));
    }

    @Test
    public void testLowerCasePP() throws Exception {
        this.checkParsePosition(this.input.toLowerCase(this.locale));
    }

    @Test
    public void testOriginal() throws Exception {
        this.checkParse(this.input);
    }

    @Test
    public void testOriginalPP() throws Exception {
        this.checkParsePosition(this.input);
    }

    @Test
    public void testUpperCase() throws Exception {
        this.checkParse(this.input.toUpperCase(this.locale));
    }

    @Test
    public void testUpperCasePP() throws Exception {
        this.checkParsePosition(this.input.toUpperCase(this.locale));
    }
}

