/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.net.URI;
import org.apache.logging.log4j.core.util.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileUtilsTest {
    private static final String LOG4J_CONFIG_WITH_PLUS = "log4j+config+with+plus+characters.xml";

    @Test
    public void testFileFromUriWithPlusCharactersInName() throws Exception {
        String config = "target/test-classes/log4j+config+with+plus+characters.xml";
        URI uri = new URI("target/test-classes/log4j+config+with+plus+characters.xml");
        File file = FileUtils.fileFromUri((URI)uri);
        Assertions.assertEquals((Object)LOG4J_CONFIG_WITH_PLUS, (Object)file.getName());
        Assertions.assertTrue((boolean)file.exists(), (String)"file exists");
    }

    @Test
    public void testAbsoluteFileFromUriWithPlusCharactersInName() throws Exception {
        String config = "target/test-classes/log4j+config+with+plus+characters.xml";
        URI uri = new File("target/test-classes/log4j+config+with+plus+characters.xml").toURI();
        File file = FileUtils.fileFromUri((URI)uri);
        Assertions.assertEquals((Object)LOG4J_CONFIG_WITH_PLUS, (Object)file.getName());
        Assertions.assertTrue((boolean)file.exists(), (String)"file exists");
    }

    @Test
    public void testAbsoluteFileFromUriWithSpacesInName() throws Exception {
        String config = "target/test-classes/s p a c e s/log4j+config+with+plus+characters.xml";
        URI uri = new File("target/test-classes/s p a c e s/log4j+config+with+plus+characters.xml").toURI();
        File file = FileUtils.fileFromUri((URI)uri);
        Assertions.assertEquals((Object)LOG4J_CONFIG_WITH_PLUS, (Object)file.getName());
        Assertions.assertTrue((boolean)file.exists(), (String)"file exists");
    }

    @Test
    public void testAbsoluteFileFromJBossVFSUri() throws Exception {
        String config = "target/test-classes/log4j+config+with+plus+characters.xml";
        String uriStr = new File("target/test-classes/log4j+config+with+plus+characters.xml").toURI().toString().replaceAll("^file:", "vfsfile:");
        Assertions.assertTrue((boolean)uriStr.startsWith("vfsfile:"));
        URI uri = URI.create(uriStr);
        File file = FileUtils.fileFromUri((URI)uri);
        Assertions.assertEquals((Object)LOG4J_CONFIG_WITH_PLUS, (Object)file.getName());
        Assertions.assertTrue((boolean)file.exists(), (String)"file exists");
    }

    @Test
    public void testFileFromUriWithSpacesAndPlusCharactersInName() throws Exception {
        String config = "target/test-classes/s%20p%20a%20c%20e%20s/log4j%2Bconfig%2Bwith%2Bplus%2Bcharacters.xml";
        URI uri = new URI("target/test-classes/s%20p%20a%20c%20e%20s/log4j%2Bconfig%2Bwith%2Bplus%2Bcharacters.xml");
        File file = FileUtils.fileFromUri((URI)uri);
        Assertions.assertEquals((Object)LOG4J_CONFIG_WITH_PLUS, (Object)file.getName());
        Assertions.assertTrue((boolean)file.exists(), (String)"file exists");
    }
}

