/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractStringLayoutTest {
    @Test
    public void testGetStringBuilderCapacityRestrictedToMax() throws Exception {
        StringBuilder sb = ConcreteStringLayout.getStringBuilder();
        int initialCapacity = sb.capacity();
        Assertions.assertEquals((int)ConcreteStringLayout.DEFAULT_STRING_BUILDER_SIZE, (int)sb.capacity(), (String)"initial capacity");
        int SMALL = 100;
        String smallMessage = new String(new char[100]);
        sb.append(smallMessage);
        Assertions.assertEquals((int)initialCapacity, (int)sb.capacity(), (String)"capacity not grown");
        Assertions.assertEquals((int)100, (int)sb.length(), (String)"length=msg length");
        StringBuilder sb2 = ConcreteStringLayout.getStringBuilder();
        Assertions.assertEquals((int)sb2.capacity(), (int)initialCapacity, (String)"capacity unchanged");
        Assertions.assertEquals((int)0, (int)sb2.length(), (String)"empty, ready for use");
        int LARGE = ConcreteStringLayout.MAX_STRING_BUILDER_SIZE * 2;
        String largeMessage = new String(new char[LARGE]);
        sb2.append(largeMessage);
        Assertions.assertTrue((sb2.capacity() >= LARGE ? 1 : 0) != 0, (String)"capacity grown to fit msg length");
        Assertions.assertTrue((sb2.capacity() >= ConcreteStringLayout.MAX_STRING_BUILDER_SIZE ? 1 : 0) != 0, (String)"capacity is now greater than max length");
        Assertions.assertEquals((int)LARGE, (int)sb2.length(), (String)"length=msg length");
        sb2.setLength(0);
        Assertions.assertEquals((int)0, (int)sb2.length(), (String)"empty, cleared");
        Assertions.assertTrue((sb2.capacity() >= ConcreteStringLayout.MAX_STRING_BUILDER_SIZE ? 1 : 0) != 0, (String)"capacity remains very large");
        StringBuilder sb3 = ConcreteStringLayout.getStringBuilder();
        Assertions.assertEquals((int)ConcreteStringLayout.MAX_STRING_BUILDER_SIZE, (int)sb3.capacity(), (String)"capacity, trimmed to MAX_STRING_BUILDER_SIZE");
        Assertions.assertEquals((int)0, (int)sb3.length(), (String)"empty, ready for use");
    }

    static class ConcreteStringLayout
    extends AbstractStringLayout {
        public static int DEFAULT_STRING_BUILDER_SIZE = 1024;
        public static int MAX_STRING_BUILDER_SIZE = AbstractStringLayout.MAX_STRING_BUILDER_SIZE;

        public ConcreteStringLayout() {
            super(Charset.defaultCharset());
        }

        public static StringBuilder getStringBuilder() {
            return AbstractStringLayout.getStringBuilder();
        }

        public String toSerializable(LogEvent event) {
            return null;
        }
    }
}

