/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import org.apache.logging.log4j.core.impl.JdkMapAdapterStringMap;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.TriConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JdkMapAdapterStringMapTest {
    static TriConsumer<String, String, State> COUNTER = (key, value, state) -> {
        ++state.count;
        Assertions.assertTrue((state.count <= state.data.size() ? 1 : 0) != 0, (String)("count should not exceed size but was " + state.count));
    };

    @Test
    public void testConstructorDisallowsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new JdkMapAdapterStringMap(null));
    }

    @Test
    public void testToString() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("a2", (Object)"bvalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("C", (Object)"Cvalue");
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)"{3=3value, B=Bvalue, C=Cvalue, a=avalue, a2=bvalue}", (Object)original.toString());
    }

    @Test
    public void testSerialization() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        byte[] binary = this.serialize(original);
        JdkMapAdapterStringMap copy = this.deserialize(binary);
        Assertions.assertEquals((Object)original, (Object)copy);
    }

    private byte[] serialize(JdkMapAdapterStringMap data) throws IOException {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(arr);
        out.writeObject(data);
        return arr.toByteArray();
    }

    private JdkMapAdapterStringMap deserialize(byte[] binary) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inArr = new ByteArrayInputStream(binary);
        ObjectInputStream in = new ObjectInputStream(inArr);
        JdkMapAdapterStringMap result = (JdkMapAdapterStringMap)in.readObject();
        return result;
    }

    @Test
    public void testPutAll() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putAll((ReadOnlyStringMap)original);
        Assertions.assertEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"otherValue");
        Assertions.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", null);
        Assertions.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)original, (Object)other);
    }

    @Test
    public void testPutAll_overwritesSameKeys2() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("a", (Object)"aa");
        other.putValue("c", (Object)"cc");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)7, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"cc", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assertions.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"22", (Object)original.getValue("2"));
    }

    @Test
    public void testPutAll_nullKeyInLargeOriginal() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)7, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"cORIG", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assertions.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"nullORIG", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInSmallOriginal() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("3", (Object)"33");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)6, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"22", (Object)original.getValue("2"));
        Assertions.assertEquals((Object)"33", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"nullORIG", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInSmallAdditional() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)7, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"cORIG", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assertions.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInLargeAdditional() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("3", (Object)"33");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)6, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"22", (Object)original.getValue("2"));
        Assertions.assertEquals((Object)"33", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInBoth_LargeOriginal() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)7, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"cORIG", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assertions.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInBoth_SmallOriginal() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("3", (Object)"33");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)6, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"22", (Object)original.getValue("2"));
        Assertions.assertEquals((Object)"33", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_overwritesSameKeys1() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("a", (Object)"aa");
        other.putValue("c", (Object)"cc");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)5, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"cc", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"22", (Object)original.getValue("2"));
    }

    @Test
    public void testEquals() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)original, (Object)original);
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("a", (Object)"avalue");
        Assertions.assertNotEquals((Object)original, (Object)other);
        other.putValue("B", (Object)"Bvalue");
        Assertions.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"otherValue");
        Assertions.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", null);
        Assertions.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)original, (Object)other);
    }

    @Test
    public void testToMap() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a", "avalue");
        expected.put("B", "Bvalue");
        expected.put("3", "3value");
        Assertions.assertEquals(expected, (Object)original.toMap());
        try {
            original.toMap().put("abc", "xyz");
        }
        catch (UnsupportedOperationException ex) {
            Assertions.fail((String)("Expected map to be mutable, but " + ex));
        }
    }

    @Test
    public void testPutAll_KeepsExistingValues() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        Assertions.assertEquals((int)3, (int)original.size(), (String)"size");
        original.putAll((ReadOnlyStringMap)new JdkMapAdapterStringMap());
        Assertions.assertEquals((int)3, (int)original.size(), (String)"size after put empty");
        Assertions.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("1", (Object)"111");
        other.putValue("2", (Object)"222");
        other.putValue("3", (Object)"333");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)6, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"111", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"222", (Object)original.getValue("2"));
        Assertions.assertEquals((Object)"333", (Object)original.getValue("3"));
    }

    @Test
    public void testPutAll_sizePowerOfTwo() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        original.putValue("d", (Object)"ddd");
        Assertions.assertEquals((int)4, (int)original.size(), (String)"size");
        original.putAll((ReadOnlyStringMap)new JdkMapAdapterStringMap());
        Assertions.assertEquals((int)4, (int)original.size(), (String)"size after put empty");
        Assertions.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"ddd", (Object)original.getValue("d"));
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("1", (Object)"111");
        other.putValue("2", (Object)"222");
        other.putValue("3", (Object)"333");
        other.putValue("4", (Object)"444");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)8, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"ddd", (Object)original.getValue("d"));
        Assertions.assertEquals((Object)"111", (Object)original.getValue("1"));
        Assertions.assertEquals((Object)"222", (Object)original.getValue("2"));
        Assertions.assertEquals((Object)"333", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"444", (Object)original.getValue("4"));
    }

    @Test
    public void testPutAll_largeAddition() {
        int i;
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue(null, (Object)"nullVal");
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        original.putValue("d", (Object)"ddd");
        Assertions.assertEquals((int)5, (int)original.size(), (String)"size");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        for (i = 0; i < 500; ++i) {
            other.putValue(String.valueOf(i), (Object)String.valueOf(i));
        }
        other.putValue(null, (Object)"otherVal");
        original.putAll((ReadOnlyStringMap)other);
        Assertions.assertEquals((int)505, (int)original.size(), (String)"size after put other");
        Assertions.assertEquals((Object)"otherVal", (Object)original.getValue(null));
        Assertions.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assertions.assertEquals((Object)"ddd", (Object)original.getValue("d"));
        for (i = 0; i < 500; ++i) {
            Assertions.assertEquals((Object)String.valueOf(i), (Object)original.getValue(String.valueOf(i)));
        }
    }

    @Test
    public void testPutAllSelfDoesNotModify() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        Assertions.assertEquals((int)3, (int)original.size(), (String)"size");
        original.putAll((ReadOnlyStringMap)original);
        Assertions.assertEquals((int)3, (int)original.size(), (String)"size after put empty");
        Assertions.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assertions.assertEquals((Object)"ccc", (Object)original.getValue("c"));
    }

    @Test
    public void testNoConcurrentModificationBiConsumerPut() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.putValue("d", (Object)"aaa");
        original.putValue("e", (Object)"aaa");
        original.forEach((s, o) -> original.putValue("c" + s, (Object)"other"));
    }

    @Test
    public void testNoConcurrentModificationBiConsumerPutValue() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.putValue("d", (Object)"aaa");
        original.putValue("e", (Object)"aaa");
        original.forEach((s, o) -> original.putValue("c" + s, (Object)"other"));
    }

    @Test
    public void testNoConcurrentModificationBiConsumerRemove() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.forEach((s, o) -> original.remove("a"));
    }

    @Test
    public void testNoConcurrentModificationBiConsumerClear() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.putValue("d", (Object)"aaa");
        original.putValue("e", (Object)"aaa");
        original.forEach((s, o) -> original.clear());
    }

    @Test
    public void testNoConcurrentModificationTriConsumerPut() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("d", (Object)"aaa");
        original.putValue("e", (Object)"aaa");
        original.forEach((s, o, o2) -> original.putValue("c", (Object)"other"), null);
    }

    @Test
    public void testNoConcurrentModificationTriConsumerPutValue() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.putValue("d", (Object)"aaa");
        original.putValue("e", (Object)"aaa");
        original.forEach((s, o, o2) -> original.putValue("c" + s, (Object)"other"), null);
    }

    @Test
    public void testNoConcurrentModificationTriConsumerRemove() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.forEach((s, o, o2) -> original.remove("a"), null);
    }

    @Test
    public void testNoConcurrentModificationTriConsumerClear() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.putValue("d", (Object)"aaa");
        original.forEach((s, o, o2) -> original.clear(), null);
    }

    @Test
    public void testInitiallyNotFrozen() {
        Assertions.assertFalse((boolean)new JdkMapAdapterStringMap().isFrozen());
    }

    @Test
    public void testIsFrozenAfterCallingFreeze() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        Assertions.assertFalse((boolean)original.isFrozen(), (String)"before freeze");
        original.freeze();
        Assertions.assertTrue((boolean)original.isFrozen(), (String)"after freeze");
    }

    @Test
    public void testFreezeProhibitsPutValue() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> original.putValue("a", (Object)"aaa"));
    }

    @Test
    public void testFreezeProhibitsRemove() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("b", (Object)"bbb");
        original.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> original.remove("b"));
    }

    @Test
    public void testFreezeAllowsRemoveOfNonExistingKey() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("b", (Object)"bbb");
        original.freeze();
        original.remove("a");
    }

    @Test
    public void testFreezeAllowsRemoveIfEmpty() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.freeze();
        original.remove("a");
    }

    @Test
    public void testFreezeProhibitsClear() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((JdkMapAdapterStringMap)original).clear());
    }

    @Test
    public void testFreezeAllowsClearIfEmpty() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.freeze();
        original.clear();
    }

    @Test
    public void testNullKeysAllowed() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        Assertions.assertEquals((int)5, (int)original.size());
        original.putValue(null, (Object)"nullvalue");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals((Object)"nullvalue", (Object)original.getValue(null));
        original.putValue(null, (Object)"otherNullvalue");
        Assertions.assertEquals((Object)"otherNullvalue", (Object)original.getValue(null));
        Assertions.assertEquals((int)6, (int)original.size());
        original.putValue(null, (Object)"nullvalue");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals((Object)"nullvalue", (Object)original.getValue(null));
        original.putValue(null, (Object)"abc");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals((Object)"abc", (Object)original.getValue(null));
    }

    @Test
    public void testNullKeysCopiedToAsMap() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        Assertions.assertEquals((int)5, (int)original.size());
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a", "avalue");
        expected.put("B", "Bvalue");
        expected.put("3", "3value");
        expected.put("c", "cvalue");
        expected.put("d", "dvalue");
        Assertions.assertEquals(expected, (Object)original.toMap(), (String)"initial");
        original.putValue(null, (Object)"nullvalue");
        expected.put(null, "nullvalue");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals(expected, (Object)original.toMap(), (String)"with null key");
        original.putValue(null, (Object)"otherNullvalue");
        expected.put(null, "otherNullvalue");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals(expected, (Object)original.toMap(), (String)"with null key value2");
        original.putValue(null, (Object)"nullvalue");
        expected.put(null, "nullvalue");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals(expected, (Object)original.toMap(), (String)"with null key value1 again");
        original.putValue(null, (Object)"abc");
        expected.put(null, "abc");
        Assertions.assertEquals((int)6, (int)original.size());
        Assertions.assertEquals(expected, (Object)original.toMap(), (String)"with null key value3");
    }

    @Test
    public void testRemove() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        Assertions.assertEquals((int)1, (int)original.size());
        Assertions.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        original.remove("a");
        Assertions.assertEquals((int)0, (int)original.size());
        Assertions.assertNull((Object)original.getValue("a"), (String)"no a val");
        original.remove("B");
        Assertions.assertEquals((int)0, (int)original.size());
        Assertions.assertNull((Object)original.getValue("B"), (String)"no B val");
    }

    @Test
    public void testRemoveWhenFull() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("b", (Object)"bvalue");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        original.remove("d");
    }

    @Test
    public void testNullValuesArePreserved() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        Assertions.assertEquals((int)1, (int)original.size());
        Assertions.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        original.putValue("a", null);
        Assertions.assertEquals((int)1, (int)original.size());
        Assertions.assertNull((Object)original.getValue("a"), (String)"no a val");
        original.putValue("B", null);
        Assertions.assertEquals((int)2, (int)original.size());
        Assertions.assertNull((Object)original.getValue("B"), (String)"no B val");
    }

    @Test
    public void testGet() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assertions.assertEquals((Object)"3value", (Object)original.getValue("3"));
        original.putValue("0", (Object)"0value");
        Assertions.assertEquals((Object)"0value", (Object)original.getValue("0"));
        Assertions.assertEquals((Object)"3value", (Object)original.getValue("3"));
        Assertions.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assertions.assertEquals((Object)"avalue", (Object)original.getValue("a"));
    }

    @Test
    public void testClear() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((int)3, (int)original.size());
        original.clear();
        Assertions.assertEquals((int)0, (int)original.size());
    }

    @Test
    public void testContainsKey() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        Assertions.assertFalse((boolean)original.containsKey("a"), (String)"a");
        Assertions.assertFalse((boolean)original.containsKey("B"), (String)"B");
        Assertions.assertFalse((boolean)original.containsKey("3"), (String)"3");
        Assertions.assertFalse((boolean)original.containsKey("A"), (String)"A");
        original.putValue("a", (Object)"avalue");
        Assertions.assertTrue((boolean)original.containsKey("a"), (String)"a");
        Assertions.assertFalse((boolean)original.containsKey("B"), (String)"B");
        Assertions.assertFalse((boolean)original.containsKey("3"), (String)"3");
        Assertions.assertFalse((boolean)original.containsKey("A"), (String)"A");
        original.putValue("B", (Object)"Bvalue");
        Assertions.assertTrue((boolean)original.containsKey("a"), (String)"a");
        Assertions.assertTrue((boolean)original.containsKey("B"), (String)"B");
        Assertions.assertFalse((boolean)original.containsKey("3"), (String)"3");
        Assertions.assertFalse((boolean)original.containsKey("A"), (String)"A");
        original.putValue("3", (Object)"3value");
        Assertions.assertTrue((boolean)original.containsKey("a"), (String)"a");
        Assertions.assertTrue((boolean)original.containsKey("B"), (String)"B");
        Assertions.assertTrue((boolean)original.containsKey("3"), (String)"3");
        Assertions.assertFalse((boolean)original.containsKey("A"), (String)"A");
        original.putValue("A", (Object)"AAA");
        Assertions.assertTrue((boolean)original.containsKey("a"), (String)"a");
        Assertions.assertTrue((boolean)original.containsKey("B"), (String)"B");
        Assertions.assertTrue((boolean)original.containsKey("3"), (String)"3");
        Assertions.assertTrue((boolean)original.containsKey("A"), (String)"A");
    }

    @Test
    public void testSizeAndIsEmpty() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        Assertions.assertEquals((int)0, (int)original.size());
        Assertions.assertTrue((boolean)original.isEmpty(), (String)"initial");
        original.putValue("a", (Object)"avalue");
        Assertions.assertEquals((int)1, (int)original.size());
        Assertions.assertFalse((boolean)original.isEmpty(), (String)("size=" + original.size()));
        original.putValue("B", (Object)"Bvalue");
        Assertions.assertEquals((int)2, (int)original.size());
        Assertions.assertFalse((boolean)original.isEmpty(), (String)("size=" + original.size()));
        original.putValue("3", (Object)"3value");
        Assertions.assertEquals((int)3, (int)original.size());
        Assertions.assertFalse((boolean)original.isEmpty(), (String)("size=" + original.size()));
        original.remove("B");
        Assertions.assertEquals((int)2, (int)original.size());
        Assertions.assertFalse((boolean)original.isEmpty(), (String)("size=" + original.size()));
        original.remove("3");
        Assertions.assertEquals((int)1, (int)original.size());
        Assertions.assertFalse((boolean)original.isEmpty(), (String)("size=" + original.size()));
        original.remove("a");
        Assertions.assertEquals((int)0, (int)original.size());
        Assertions.assertTrue((boolean)original.isEmpty(), (String)("size=" + original.size()));
    }

    @Test
    public void testForEachBiConsumer() throws Exception {
        final JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.forEach((BiConsumer)new BiConsumer<String, String>(){
            int count = 0;

            public void accept(String key, String value) {
                ++this.count;
                Assertions.assertTrue((this.count <= original.size() ? 1 : 0) != 0, (String)("count should not exceed size but was " + this.count));
            }
        });
    }

    @Test
    public void testForEachTriConsumer() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        State state = new State();
        state.data = original;
        original.forEach(COUNTER, (Object)state);
        Assertions.assertEquals((int)state.count, (int)original.size());
    }

    static class State {
        JdkMapAdapterStringMap data;
        int count;

        State() {
        }
    }
}

