/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PluginManagerPackagesTest {
    private static Configuration config;
    private static ListAppender listAppender;
    private static LoggerContext ctx;

    @AfterAll
    public static void cleanupClass() {
        System.clearProperty("log4j.configurationFile");
        ctx.reconfigure();
        StatusLogger.getLogger().reset();
    }

    @Test
    public void test() throws Exception {
        File orig = new File("target/test-classes/customplugin/FixedStringLayout.java.source");
        File f = new File(orig.getParentFile(), "FixedStringLayout.java");
        Assertions.assertTrue((boolean)orig.renameTo(f), (String)"renamed source file failed");
        PluginManagerPackagesTest.compile(f);
        Assertions.assertTrue((boolean)f.renameTo(orig), (String)"reverted source file failed");
        Class.forName("customplugin.FixedStringLayout");
        ctx = Configurator.initialize((String)"Test1", (String)"customplugin/log4j2-741.xml");
        config = ctx.getConfiguration();
        listAppender = (ListAppender)config.getAppender("List");
        Logger logger = LogManager.getLogger(PluginManagerPackagesTest.class);
        logger.info("this message is ignored");
        List<String> messages = listAppender.getMessages();
        Assertions.assertEquals((int)1, (int)messages.size(), (String)messages.toString());
        Assertions.assertEquals((Object)"abc123XYZ", (Object)messages.get(0));
    }

    static void compile(File f) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ArrayList<String> errors = new ArrayList<String>();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);){
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Collections.singletonList(f));
            List<String> options = Collections.singletonList("-proc:none");
            compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits).call();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                errors.add(String.format("Compile error: %s%n", diagnostic.getMessage(Locale.getDefault())));
            }
        }
        Assertions.assertTrue((boolean)errors.isEmpty(), (String)((Object)errors).toString());
    }
}

