/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.junit.CleanUpFiles;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusConsoleListener;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

@CleanUpFiles(value={"target/test.log"})
public class CustomConfigurationTest {
    public static final Path LOG_FILE = Paths.get("target", "test.log");

    @BeforeAll
    public static void before() {
        System.setProperty("log4j.level", "info");
        System.setProperty("log.level", "info");
    }

    @Test
    @LoggerContextSource(value="log4j-props.xml")
    public void testConfig(LoggerContext ctx) throws IOException {
        Configuration config = ctx.getConfiguration();
        MatcherAssert.assertThat((Object)config, (Matcher)Matchers.instanceOf(XmlConfiguration.class));
        for (StatusListener listener : StatusLogger.getLogger().getListeners()) {
            if (!(listener instanceof StatusConsoleListener)) continue;
            Assertions.assertSame((Object)listener.getStatusLevel(), (Object)Level.INFO);
            break;
        }
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d [%t] %p %c - %m%n").withConfiguration(config).build();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(LOG_FILE.toString()).withAppend(false).setName("File")).setIgnoreExceptions(false)).withBufferSize(4000)).withBufferedIo(false)).setLayout((Layout)layout)).build();
        appender.start();
        config.addAppender((Appender)appender);
        AppenderRef ref = AppenderRef.createAppenderRef((String)"File", null, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.INFO, (String)"org.apache.logging.log4j", (String)"true", (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfig.addAppender((Appender)appender, null, null);
        config.addLogger("org.apache.logging.log4j", loggerConfig);
        ctx.updateLoggers();
        ExtendedLogger logger = ctx.getLogger(CustomConfigurationTest.class);
        logger.info("This is a test");
        Assertions.assertTrue((boolean)Files.exists(LOG_FILE, new LinkOption[0]));
        MatcherAssert.assertThat((Object)Files.size(LOG_FILE), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }
}

