/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingDirectTimeNewDirectoryTest {
    private static final String CONFIG = "log4j-rolling-folder-direct.xml";
    private static final String DIR = "target/rolling-folder-direct";
    public static LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-folder-direct.xml");
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/rolling-folder-direct");

    @Test
    public void streamClosedError() throws Exception {
        int i;
        Logger logger = loggerContextRule.getLogger(RollingDirectTimeNewDirectoryTest.class.getName());
        for (i = 0; i < 1000; ++i) {
            logger.info("nHq6p9kgfvWfjzDRYbZp");
        }
        Thread.sleep(1500L);
        for (i = 0; i < 1000; ++i) {
            logger.info("nHq6p9kgfvWfjzDRYbZp");
        }
        File logDir = new File(DIR);
        Object[] logFolders = logDir.listFiles();
        Assert.assertNotNull((Object)logFolders);
        Arrays.sort(logFolders);
        int totalFiles = 0;
        try {
            int minExpectedLogFolderCount = 2;
            Assert.assertTrue((String)("was expecting at least 2 folders, found " + logFolders.length), (logFolders.length >= 2 ? 1 : 0) != 0);
            for (Object logFolder : logFolders) {
                File[] logFiles = ((File)logFolder).listFiles();
                if (logFiles == null) continue;
                Assert.assertTrue((String)("Only 1 file per folder expected: got " + logFiles.length), (logFiles.length <= 1 ? 1 : 0) != 0);
                totalFiles += logFiles.length;
            }
            Assert.assertTrue((String)"Expected at least 2 files", (totalFiles >= 2 ? 1 : 0) != 0);
        }
        catch (AssertionError error) {
            System.out.format("log directory (%s) contents:%n", DIR);
            Iterator fileIterator = FileUtils.iterateFilesAndDirs((File)logDir, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE);
            int totalFileCount = 0;
            while (fileIterator.hasNext()) {
                ++totalFileCount;
                File file = (File)fileIterator.next();
                System.out.format("-> %s (%d)%n", file, file.length());
            }
            System.out.format("total file count: %d%n", totalFileCount);
            throw new AssertionError("check failure", (Throwable)((Object)error));
        }
    }
}

