/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.FileExtension;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderSizeCompressPermissionsTest {
    private static final String CONFIG = "log4j-rolling-gz-posix.xml";
    private static final String DIR = "target/rollingpermissions1";
    public static LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-gz-posix.xml");
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/rollingpermissions1");
    private Logger logger;

    @BeforeClass
    public static void beforeClass() {
        Assume.assumeTrue((boolean)FileUtils.isFilePosixAttributeViewSupported());
    }

    @Before
    public void setUp() throws Exception {
        this.logger = loggerContextRule.getLogger(RollingAppenderSizeCompressPermissionsTest.class.getName());
    }

    @Test
    public void testAppenderCompressPermissions() throws Exception {
        for (int i = 0; i < 500; ++i) {
            String message = "This is test message number " + i;
            this.logger.debug(message);
            if (i % 100 != 0) continue;
            Thread.sleep(500L);
        }
        if (!loggerContextRule.getLoggerContext().stop(30L, TimeUnit.SECONDS)) {
            System.err.println("Could not stop cleanly " + loggerContextRule + " for " + this);
        }
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (boolean)dir.exists());
        File[] files = dir.listFiles();
        Assert.assertNotNull((Object)files);
        int gzippedFiles1 = 0;
        int gzippedFiles2 = 0;
        for (File file : files) {
            FileExtension ext = FileExtension.lookupForFile((String)file.getName());
            if (ext != null) {
                if (file.getName().startsWith("test1")) {
                    ++gzippedFiles1;
                    Assert.assertEquals((Object)"rw-------", (Object)PosixFilePermissions.toString(Files.getPosixFilePermissions(file.toPath(), new LinkOption[0])));
                    continue;
                }
                ++gzippedFiles2;
                Assert.assertEquals((Object)"r--r--r--", (Object)PosixFilePermissions.toString(Files.getPosixFilePermissions(file.toPath(), new LinkOption[0])));
                continue;
            }
            if (file.getName().startsWith("test1")) {
                Assert.assertEquals((Object)"rw-------", (Object)PosixFilePermissions.toString(Files.getPosixFilePermissions(file.toPath(), new LinkOption[0])));
                continue;
            }
            Assert.assertEquals((Object)"rwx------", (Object)PosixFilePermissions.toString(Files.getPosixFilePermissions(file.toPath(), new LinkOption[0])));
        }
        Assert.assertTrue((String)("Files not rolled : " + files.length), (files.length > 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Files 1 gzipped not rolled : " + gzippedFiles1), (gzippedFiles1 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Files 2 gzipped not rolled : " + gzippedFiles2), (gzippedFiles2 > 0 ? 1 : 0) != 0);
    }
}

