/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderDeleteScriptFri13thTest {
    private static final String CONFIG = "log4j-rolling-with-custom-delete-script-fri13th.xml";
    private static final String DIR = "target/rolling-with-delete-script-fri13th/test";
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-with-custom-delete-script-fri13th.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling-with-delete-script-fri13th/test");

    @Test
    public void testAppender() throws Exception {
        File[] files;
        File dir = new File(DIR);
        dir.mkdirs();
        for (int i = 1; i <= 30; ++i) {
            String day = i < 10 ? "0" + i : "" + i;
            new File(dir, "test-201511" + day + "-0.log").createNewFile();
        }
        Assert.assertEquals((String)"Dir target/rolling-with-delete-script-fri13th/test filecount", (long)30L, (long)dir.listFiles().length);
        Logger logger = this.loggerContextRule.getLogger();
        while (dir.listFiles().length < 32) {
            logger.debug("This is a very, very, very, very long test message.............");
            Thread.sleep(100L);
        }
        for (File file : files = dir.listFiles()) {
            System.out.println(file);
        }
        for (File file : files) {
            Assert.assertTrue((String)(file.getName() + " starts with 'test-'"), (boolean)file.getName().startsWith("test-"));
            Assert.assertTrue((String)(file.getName() + " ends with '.log'"), (boolean)file.getName().endsWith(".log"));
            String strDate = file.getName().substring(5, 13);
            Assert.assertFalse((String)(file + " is not Fri 13th"), (boolean)strDate.endsWith("20151113"));
        }
    }
}

