/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.logging.log4j.core.appender.db.jdbc.FactoryMethodConnectionSource;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class FactoryMethodConnectionSourceTest {
    private static ThreadLocal<Object> holder = new ThreadLocal();
    private static final String CONFIG = "log4j-fatalOnly.xml";
    @ClassRule
    public static LoggerContextRule ctx = new LoggerContextRule("log4j-fatalOnly.xml");

    @After
    public void tearDown() {
        holder.remove();
    }

    @Test
    public void testNoClassName() {
        FactoryMethodConnectionSource source = FactoryMethodConnectionSource.createConnectionSource(null, (String)"method");
        Assert.assertNull((String)"The connection source should be null.", (Object)source);
    }

    @Test
    public void testNoMethodName() {
        FactoryMethodConnectionSource source = FactoryMethodConnectionSource.createConnectionSource((String)"someClass", null);
        Assert.assertNull((String)"The connection source should be null.", (Object)source);
    }

    @Test
    public void testBadClassName() {
        FactoryMethodConnectionSource source = FactoryMethodConnectionSource.createConnectionSource((String)"org.apache.BadClass", (String)"factoryMethod");
        Assert.assertNull((String)"The connection source should be null.", (Object)source);
    }

    @Test
    public void testBadMethodName() {
        FactoryMethodConnectionSource source = FactoryMethodConnectionSource.createConnectionSource((String)this.getClass().getName(), (String)"factoryMethod");
        Assert.assertNull((String)"The connection source should be null.", (Object)source);
    }

    @Test
    public void testBadReturnType() {
        FactoryMethodConnectionSource source = FactoryMethodConnectionSource.createConnectionSource((String)BadReturnTypeFactory.class.getName(), (String)"factoryMethod01");
        Assert.assertNull((String)"The connection source should be null.", (Object)source);
    }

    @Test
    public void testDataSourceReturnType() throws SQLException {
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        try (Connection connection1 = (Connection)Mockito.mock(Connection.class);
             Connection connection2 = (Connection)Mockito.mock(Connection.class);){
            BDDMockito.given((Object)dataSource.getConnection()).willReturn((Object)connection1, (Object[])new Connection[]{connection2});
            holder.set(dataSource);
            FactoryMethodConnectionSource source = FactoryMethodConnectionSource.createConnectionSource((String)DataSourceFactory.class.getName(), (String)"factoryMethod02");
            Assert.assertNotNull((String)"The connection source should not be null.", (Object)source);
            Assert.assertEquals((String)"The toString value is not correct.", (Object)("factory{ public static javax.sql.DataSource[" + dataSource + "] " + DataSourceFactory.class.getName() + ".factoryMethod02() }"), (Object)source.toString());
            Assert.assertSame((String)"The connection is not correct (1).", (Object)connection1, (Object)source.getConnection());
            Assert.assertSame((String)"The connection is not correct (2).", (Object)connection2, (Object)source.getConnection());
        }
    }

    @Test
    public void testConnectionReturnType() throws SQLException {
        try (Connection connection = (Connection)Mockito.mock(Connection.class);){
            holder.set(connection);
            FactoryMethodConnectionSource source = FactoryMethodConnectionSource.createConnectionSource((String)ConnectionFactory.class.getName(), (String)"anotherMethod03");
            Assert.assertNotNull((String)"The connection source should not be null.", (Object)source);
            Assert.assertEquals((String)"The toString value is not correct.", (Object)("factory{ public static java.sql.Connection " + ConnectionFactory.class.getName() + ".anotherMethod03() }"), (Object)source.toString());
            Assert.assertSame((String)"The connection is not correct (1).", (Object)connection, (Object)source.getConnection());
            Assert.assertSame((String)"The connection is not correct (2).", (Object)connection, (Object)source.getConnection());
        }
    }

    protected static final class ConnectionFactory {
        protected ConnectionFactory() {
        }

        public static Connection anotherMethod03() {
            return (Connection)holder.get();
        }
    }

    protected static final class DataSourceFactory {
        protected DataSourceFactory() {
        }

        public static DataSource factoryMethod02() {
            return (DataSource)holder.get();
        }
    }

    protected static final class BadReturnTypeFactory {
        protected BadReturnTypeFactory() {
        }

        public static String factoryMethod01() {
            return "hello";
        }
    }
}

