/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.async.DefaultAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.BlockingAppender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-asynch-queue-full.xml")
public class AsyncAppenderQueueFullPolicyTest {
    private final BlockingAppender blockingAppender;
    private final AsyncAppender asyncAppender;
    private final CountingAsyncQueueFullPolicy policy;

    public AsyncAppenderQueueFullPolicyTest(@Named(value="Block") BlockingAppender blockingAppender, @Named(value="Async") AsyncAppender asyncAppender) throws Exception {
        this.blockingAppender = blockingAppender;
        this.asyncAppender = asyncAppender;
        Field field = AsyncAppender.class.getDeclaredField("asyncQueueFullPolicy");
        field.setAccessible(true);
        this.policy = new CountingAsyncQueueFullPolicy();
        field.set(asyncAppender, (Object)this.policy);
        this.policy.queueFull.set(0L);
    }

    @AfterEach
    public void after() {
        this.blockingAppender.running = false;
        this.policy.queueFull.set(0L);
    }

    @Test
    public void testRouter() throws Exception {
        Logger logger = LogManager.getLogger(AsyncAppenderQueueFullPolicyTest.class);
        Assertions.assertEquals((int)4, (int)this.asyncAppender.getQueueCapacity());
        logger.error("event 1 - gets taken off the queue");
        logger.warn("event 2");
        logger.info("event 3");
        logger.info("event 4");
        while (this.asyncAppender.getQueueRemainingCapacity() == 0) {
            Thread.yield();
        }
        logger.info("event 5 - now the queue is full");
        Assertions.assertEquals((int)0, (int)this.asyncAppender.getQueueRemainingCapacity(), (String)"queue remaining capacity");
        Assertions.assertEquals((long)0L, (long)this.policy.queueFull.get(), (String)"EventRouter invocations");
        Thread release = new Thread("AsyncAppenderReleaser"){

            @Override
            public void run() {
                while (((AsyncAppenderQueueFullPolicyTest)AsyncAppenderQueueFullPolicyTest.this).policy.queueFull.get() == 0L) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ((AsyncAppenderQueueFullPolicyTest)AsyncAppenderQueueFullPolicyTest.this).blockingAppender.running = false;
            }
        };
        release.setDaemon(true);
        release.start();
        logger.fatal("this blocks until queue space available");
        Assertions.assertEquals((long)1L, (long)this.policy.queueFull.get());
    }

    public static class CountingAsyncQueueFullPolicy
    extends DefaultAsyncQueueFullPolicy {
        AtomicLong queueFull = new AtomicLong();

        public EventRoute getRoute(long backgroundThreadId, Level level) {
            this.queueFull.incrementAndGet();
            return EventRoute.ENQUEUE;
        }
    }
}

