/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import org.apache.logging.log4j.core.util.Throwables;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThrowablesTest {
    @Test
    public void testGetRootCauseNone() {
        NullPointerException throwable = new NullPointerException();
        Assertions.assertEquals((Object)throwable, (Object)Throwables.getRootCause((Throwable)throwable));
    }

    @Test
    public void testGetRootCauseDepth1() {
        NullPointerException cause = new NullPointerException();
        UnsupportedOperationException error = new UnsupportedOperationException(cause);
        Assertions.assertEquals((Object)cause, (Object)Throwables.getRootCause((Throwable)error));
    }

    @Test
    public void testGetRootCauseDepth2() {
        NullPointerException rootCause = new NullPointerException();
        UnsupportedOperationException cause = new UnsupportedOperationException(rootCause);
        IllegalArgumentException error = new IllegalArgumentException(cause);
        Assertions.assertEquals((Object)rootCause, (Object)Throwables.getRootCause((Throwable)error));
    }

    @Test
    public void testGetRootCauseLoop() {
        RuntimeException cause1 = new RuntimeException();
        RuntimeException cause2 = new RuntimeException(cause1);
        RuntimeException cause3 = new RuntimeException(cause2);
        cause1.initCause(cause3);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Throwables.getRootCause((Throwable)cause3));
    }

    @Test
    public void testRethrowRuntimeException() {
        Assertions.assertThrows(NullPointerException.class, () -> Throwables.rethrow((Throwable)new NullPointerException()));
    }

    @Test
    public void testRethrowError() {
        Assertions.assertThrows(UnknownError.class, () -> Throwables.rethrow((Throwable)new UnknownError()));
    }

    @Test
    public void testRethrowCheckedException() {
        Assertions.assertThrows(NoSuchMethodException.class, () -> Throwables.rethrow((Throwable)new NoSuchMethodException()));
    }
}

