/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

public final class Profiler {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static Object profiler;
    private static Class<?> profilingModes;
    private static Class<?> controllerClazz;

    private Profiler() {
    }

    public static boolean isActive() {
        return profiler != null;
    }

    private static long cpuSampling() throws NoSuchFieldException, IllegalAccessException {
        return profilingModes.getDeclaredField("CPU_SAMPLING").getLong(profilingModes);
    }

    private static long snapshotWithoutHeap() throws NoSuchFieldException, IllegalAccessException {
        return profilingModes.getDeclaredField("SNAPSHOT_WITHOUT_HEAP").getLong(profilingModes);
    }

    public static void start() {
        if (profiler != null) {
            try {
                controllerClazz.getMethod("startCPUProfiling", Long.TYPE, String.class).invoke(profiler, Profiler.cpuSampling(), "");
            }
            catch (Exception e) {
                LOGGER.error("Profiler was active, but failed.", (Throwable)e);
            }
        }
    }

    public static void stop() {
        if (profiler != null) {
            try {
                controllerClazz.getMethod("captureSnapshot", Long.TYPE).invoke(profiler, Profiler.snapshotWithoutHeap());
                controllerClazz.getMethod("stopCPUProfiling", new Class[0]).invoke(profiler, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Profiler was active, but failed.", (Throwable)e);
            }
        }
    }

    static {
        try {
            controllerClazz = LoaderUtil.loadClass((String)"com.yourkit.api.Controller");
            profilingModes = LoaderUtil.loadClass((String)"com.yourkit.api.ProfilingModes");
            try {
                profiler = controllerClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Profiler was active, but failed.", (Throwable)e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

