/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.SimpleLiteralPatternConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleLiteralPatternConverterTest {
    @Test
    public void testConvertBackslashes() {
        String literal = "ABC\\tDEF\\nGHI\\rJKL\\'MNO\\f \\b \\\\DROPPED:\\x";
        LogEventPatternConverter converter = SimpleLiteralPatternConverter.of((String)literal, (boolean)true);
        String actual = SimpleLiteralPatternConverterTest.literal(converter);
        Assertions.assertEquals((Object)"ABC\tDEF\nGHI\rJKL'MNO\f \b \\DROPPED:x", (Object)actual);
    }

    @Test
    public void testDontConvertBackslashes() {
        String literal = "ABC\\tDEF\\nGHI\\rJKL\\'MNO\\f \\b \\\\DROPPED:\\x";
        LogEventPatternConverter converter = SimpleLiteralPatternConverter.of((String)literal, (boolean)false);
        String actual = SimpleLiteralPatternConverterTest.literal(converter);
        Assertions.assertEquals((Object)literal, (Object)actual);
    }

    private static String literal(LogEventPatternConverter converter) {
        StringBuilder buffer = new StringBuilder();
        converter.format(null, buffer);
        return buffer.toString();
    }
}

