/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.MapPatternConverter;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MapPatternConverterTest {
    @Test
    public void testConverter() {
        StringMapMessage msg = new StringMapMessage();
        msg.put("subject", "I");
        msg.put("verb", "love");
        msg.put("object", "Log4j");
        MapPatternConverter converter = MapPatternConverter.newInstance(null);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "subject=I";
        Assertions.assertTrue((boolean)str.contains(expected), (String)("Missing or incorrect subject. Expected " + expected + ", actual " + str));
        expected = "verb=love";
        Assertions.assertTrue((boolean)str.contains(expected), (String)"Missing or incorrect verb");
        expected = "object=Log4j";
        Assertions.assertTrue((boolean)str.contains(expected), (String)"Missing or incorrect object");
        Assertions.assertEquals((Object)"{object=Log4j, subject=I, verb=love}", (Object)str);
    }

    @Test
    public void testConverterWithKey() {
        StringMapMessage msg = new StringMapMessage();
        msg.put("subject", "I");
        msg.put("verb", "love");
        msg.put("object", "Log4j");
        MapPatternConverter converter = MapPatternConverter.newInstance((String[])new String[]{"object"});
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "Log4j";
        Assertions.assertEquals((Object)"Log4j", (Object)str);
    }

    @Test
    public void testConverterWithJavaFormat() {
        StringMapMessage msg = new StringMapMessage();
        msg.put("subject", "I");
        msg.put("verb", "love");
        msg.put("object", "Log4j");
        MapPatternConverter converter = MapPatternConverter.newInstance(null, (MapMessage.MapFormat)MapMessage.MapFormat.JAVA);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "subject=\"I\"";
        Assertions.assertTrue((boolean)str.contains(expected), (String)("Missing or incorrect subject. Expected " + expected + ", actual " + str));
        expected = "verb=\"love\"";
        Assertions.assertTrue((boolean)str.contains(expected), (String)"Missing or incorrect verb");
        expected = "object=\"Log4j\"";
        Assertions.assertTrue((boolean)str.contains(expected), (String)"Missing or incorrect object");
        Assertions.assertEquals((Object)"{object=\"Log4j\", subject=\"I\", verb=\"love\"}", (Object)str);
    }
}

