/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.core.net.ssl.FilePasswordProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilePasswordProviderTest {
    @Test
    public void testGetPassword() throws Exception {
        String PASSWORD = "myPass123";
        Path path = Files.createTempFile("testPass", ".txt", new FileAttribute[0]);
        Files.write(path, "myPass123".getBytes(Charset.defaultCharset()), new OpenOption[0]);
        char[] actual = new FilePasswordProvider(path.toString()).getPassword();
        Files.delete(path);
        Assertions.assertArrayEquals((char[])"myPass123".toCharArray(), (char[])actual);
    }

    @Test
    public void testConstructorDisallowsNull() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> new FilePasswordProvider(null));
    }

    @Test
    public void testConstructorFailsIfFileDoesNotExist() throws Exception {
        Assertions.assertThrows(NoSuchFileException.class, () -> new FilePasswordProvider("nosuchfile"));
    }
}

