/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.junit.UsingAnyThreadContext;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="GelfLayoutPatternSelectorTest.xml")
@UsingAnyThreadContext
@Tag(value="json")
public class GelfLayoutPatternSelectorTest {
    @Test
    public void gelfLayout(LoggerContext context, @Named ListAppender list) throws IOException {
        list.clear();
        ExtendedLogger logger = context.getLogger(this.getClass());
        ThreadContext.put((String)"loginId", (String)"rgoers");
        ThreadContext.put((String)"internalId", (String)"12345");
        logger.info("My Test Message");
        logger.info(AbstractLogger.FLOW_MARKER, "My Test Message");
        String gelf = list.getMessages().get(0);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(gelf);
        Assertions.assertEquals((Object)"My Test Message", (Object)json.get("short_message").asText());
        Assertions.assertEquals((Object)"myhost", (Object)json.get("host").asText());
        Assertions.assertNotNull((Object)json.get("_loginId"));
        Assertions.assertEquals((Object)"rgoers", (Object)json.get("_loginId").asText());
        Assertions.assertNull((Object)json.get("_internalId"));
        Assertions.assertNull((Object)json.get("_requestId"));
        String message = json.get("full_message").asText();
        Assertions.assertFalse((boolean)message.contains("====="));
        Assertions.assertTrue((boolean)message.contains("loginId=rgoers"));
        Assertions.assertTrue((boolean)message.contains("GelfLayoutPatternSelectorTest"));
        gelf = list.getMessages().get(1);
        json = mapper.readTree(gelf);
        Assertions.assertEquals((Object)"My Test Message", (Object)json.get("short_message").asText());
        Assertions.assertEquals((Object)"myhost", (Object)json.get("host").asText());
        Assertions.assertNotNull((Object)json.get("_loginId"));
        Assertions.assertEquals((Object)"rgoers", (Object)json.get("_loginId").asText());
        Assertions.assertNull((Object)json.get("_internalId"));
        Assertions.assertNull((Object)json.get("_requestId"));
        message = json.get("full_message").asText();
        Assertions.assertTrue((boolean)message.contains("====="));
        Assertions.assertTrue((boolean)message.contains("loginId=rgoers"));
        Assertions.assertTrue((boolean)message.contains("GelfLayoutPatternSelectorTest"));
    }
}

