/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.logging.log4j.categories.Layouts;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Json.class})
public class JacksonIssue429Test {
    private static final ObjectMapper SHARED_MAPPER = new ObjectMapper();
    private final ObjectMapper MAPPER = this.objectMapper();

    protected String aposToQuotes(String json) {
        return json.replace("'", "\"");
    }

    protected ObjectMapper objectMapper() {
        return SHARED_MAPPER;
    }

    @Test
    public void testStackTraceElementWithCustom() throws Exception {
        StackTraceBean bean = (StackTraceBean)this.MAPPER.readValue(this.aposToQuotes("{'Location':'foobar'}"), StackTraceBean.class);
        Assert.assertNotNull((Object)bean);
        Assert.assertNotNull((Object)bean.location);
        Assert.assertEquals((long)13L, (long)bean.location.getLineNumber());
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(StackTraceElement.class, (JsonDeserializer)new Jackson429StackTraceElementDeserializer());
        mapper.registerModule((Module)module);
        StackTraceElement elem = (StackTraceElement)mapper.readValue(this.aposToQuotes("{'class':'package.SomeClass','method':'someMethod','file':'SomeClass.java','line':123}"), StackTraceElement.class);
        Assert.assertNotNull((Object)elem);
        Assert.assertEquals((long)13L, (long)elem.getLineNumber());
    }

    static class StackTraceBean {
        public static final int NUM = 13;
        @JsonProperty(value="Location")
        @JsonDeserialize(using=Jackson429StackTraceElementDeserializer.class)
        private StackTraceElement location;

        StackTraceBean() {
        }
    }

    static class Jackson429StackTraceElementDeserializer
    extends StdDeserializer<StackTraceElement> {
        private static final long serialVersionUID = 1L;

        public Jackson429StackTraceElementDeserializer() {
            super(StackTraceElement.class);
        }

        public StackTraceElement deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            jp.skipChildren();
            return new StackTraceElement("a", "b", "b", 13);
        }
    }
}

