/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.filter.RegexFilter;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CompositeConfigurationTest {
    @Test
    public void compositeLogger() {
        final LoggerContextRule lcr = new LoggerContextRule("classpath:log4j-comp-logger.xml,log4j-comp-logger.json");
        Statement test = new Statement(){

            public void evaluate() throws Throwable {
                CompositeConfiguration config = (CompositeConfiguration)lcr.getConfiguration();
                Map appendersMap = config.getLogger("cat1").getAppenders();
                Assert.assertEquals((String)("Expected 2 Appender references for cat1 but got " + appendersMap.size()), (long)2L, (long)appendersMap.size());
                Assert.assertTrue((boolean)(appendersMap.get("STDOUT") instanceof ConsoleAppender));
                Filter loggerFilter = config.getLogger("cat1").getFilter();
                Assert.assertTrue((boolean)(loggerFilter instanceof RegexFilter));
                Assert.assertEquals((Object)loggerFilter.getOnMatch(), (Object)Filter.Result.DENY);
                appendersMap = config.getLogger("cat2").getAppenders();
                Assert.assertEquals((String)("Expected 1 Appender reference for cat2 but got " + appendersMap.size()), (long)1L, (long)appendersMap.size());
                Assert.assertTrue((boolean)(appendersMap.get("File") instanceof FileAppender));
                appendersMap = config.getLogger("cat3").getAppenders();
                Assert.assertEquals((String)("Expected 1 Appender reference for cat3 but got " + appendersMap.size()), (long)1L, (long)appendersMap.size());
                Assert.assertTrue((boolean)(appendersMap.get("File") instanceof FileAppender));
                appendersMap = config.getRootLogger().getAppenders();
                Assert.assertEquals((String)("Expected 2 Appender references for the root logger but got " + appendersMap.size()), (long)2L, (long)appendersMap.size());
                Assert.assertTrue((boolean)(appendersMap.get("File") instanceof FileAppender));
                Assert.assertTrue((boolean)(appendersMap.get("STDOUT") instanceof ConsoleAppender));
                Assert.assertEquals((String)("Expected COMPOSITE_SOURCE for composite configuration but got " + config.getConfigurationSource()), (Object)config.getConfigurationSource(), (Object)ConfigurationSource.COMPOSITE_SOURCE);
            }
        };
        this.runTest(lcr, test);
    }

    @Test
    public void testAttributeCheckWhenMergingConfigurations() {
        final LoggerContextRule lcr = new LoggerContextRule("classpath:log4j-comp-root-loggers.xml,log4j-comp-logger.json");
        Statement test = new Statement(){

            public void evaluate() throws Throwable {
                try {
                    CompositeConfiguration config = (CompositeConfiguration)lcr.getConfiguration();
                    Assert.assertNotNull((Object)config);
                }
                catch (NullPointerException e) {
                    Assert.fail((String)"Should not throw NullPointerException when there are different nodes.");
                }
            }
        };
        this.runTest(lcr, test);
    }

    @Test
    public void testAttributeMergeForLoggers() {
        final LoggerContextRule lcr = new LoggerContextRule("classpath:log4j-comp-logger-root.xml,log4j-comp-logger-attr-override.json");
        Statement test = new Statement(){

            public void evaluate() throws Throwable {
                CompositeConfiguration config = (CompositeConfiguration)lcr.getConfiguration();
                Assert.assertEquals((String)"Expected Root logger log level to be WARN", (Object)Level.WARN, (Object)config.getRootLogger().getLevel());
                LoggerConfig cat2 = config.getLogger("cat2");
                Assert.assertEquals((String)"Expected cat2 log level to be INFO", (Object)Level.INFO, (Object)cat2.getLevel());
                Assert.assertTrue((String)"Expected cat2 additivity to be true", (boolean)cat2.isAdditive());
                Assert.assertEquals((String)"Expected cat3 log level to be ERROR", (Object)Level.ERROR, (Object)config.getLogger("cat3").getLevel());
                Assert.assertEquals((String)"Expected cat1 log level to be DEBUG", (Object)Level.DEBUG, (Object)config.getLogger("cat1").getLevel());
            }
        };
        this.runTest(lcr, test);
    }

    @Test
    public void testMissingConfig() {
        final LoggerContextRule lcr = new LoggerContextRule("classpath:log4j-comp-logger-root.xml,log4j-does-not-exist.json");
        Statement test = new Statement(){

            public void evaluate() throws Throwable {
                AbstractConfiguration config = (AbstractConfiguration)lcr.getConfiguration();
                Assert.assertNotNull((String)"No configuration returned", (Object)config);
                Assert.assertEquals((String)"Expected Root logger log level to be ERROR", (Object)Level.ERROR, (Object)config.getRootLogger().getLevel());
                LoggerConfig cat2 = config.getLogger("cat2");
                Assert.assertEquals((String)"Expected cat2 log level to be INFO", (Object)Level.DEBUG, (Object)cat2.getLevel());
            }
        };
        this.runTest(lcr, test);
    }

    @Test
    public void testAppenderRefFilterMerge() {
        final LoggerContextRule lcr = new LoggerContextRule("classpath:log4j-comp-logger-ref.xml,log4j-comp-logger-ref.json");
        Statement test = new Statement(){

            public void evaluate() throws Throwable {
                CompositeConfiguration config = (CompositeConfiguration)lcr.getConfiguration();
                List appenderRefList = config.getLogger("cat1").getAppenderRefs();
                AppenderRef appenderRef = CompositeConfigurationTest.this.getAppenderRef(appenderRefList, "STDOUT");
                Assert.assertTrue((String)"Expected cat1 STDOUT appenderRef to have a regex filter", (appenderRef.getFilter() != null && appenderRef.getFilter() instanceof RegexFilter ? 1 : 0) != 0);
            }
        };
        this.runTest(lcr, test);
    }

    private AppenderRef getAppenderRef(List<AppenderRef> appenderRefList, String refName) {
        for (AppenderRef ref : appenderRefList) {
            if (!ref.getRef().equalsIgnoreCase(refName)) continue;
            return ref;
        }
        return null;
    }

    private void runTest(LoggerContextRule rule, Statement statement) {
        try {
            rule.apply(statement, Description.createTestDescription(this.getClass(), (String)Thread.currentThread().getStackTrace()[1].getMethodName())).evaluate();
        }
        catch (Throwable e) {
            Throwables.rethrow((Throwable)e);
        }
    }
}

