/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async.perftest;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.async.perftest.Histogram;
import org.apache.logging.log4j.core.async.perftest.IPerfTestRunner;
import org.apache.logging.log4j.core.async.perftest.PerfTest;

public class MultiThreadPerfTest
extends PerfTest {
    public static void main(String[] args) throws Exception {
        new MultiThreadPerfTest().doMain(args);
    }

    @Override
    public void runTestAndPrintResult(IPerfTestRunner runner, String name, int threadCount, String resultFile) throws Exception {
        PerfTest.println("Warming up the JVM...");
        long t1 = System.nanoTime();
        Histogram warmupHist = PerfTest.createHistogram();
        long stop = System.nanoTime() + TimeUnit.MINUTES.toNanos(1L);
        Runnable run1 = () -> {
            for (int i = 0; i < 10; ++i) {
                int LINES = PerfTest.throughput ? 50000 : 200000;
                this.runTest(runner, LINES, null, warmupHist, 2);
                if (i <= 0 || System.nanoTime() - stop < 0L) continue;
                return;
            }
        };
        Thread thread1 = new Thread(run1);
        Thread thread2 = new Thread(run1);
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        PerfTest.printf("Warmup complete in %.1f seconds%n", (double)(System.nanoTime() - t1) / 1.0E9);
        PerfTest.println("Waiting 10 seconds for buffers to drain warmup data...");
        Thread.sleep(10000L);
        new File("perftest.log").delete();
        new File("perftest.log").createNewFile();
        PerfTest.println("Starting the main test...");
        PerfTest.throughput = false;
        this.multiThreadedTestRun(runner, name, threadCount, resultFile);
        Thread.sleep(1000L);
        PerfTest.throughput = true;
        this.multiThreadedTestRun(runner, name, threadCount, resultFile);
    }

    private void multiThreadedTestRun(final IPerfTestRunner runner, String name, final int threadCount, String resultFile) throws Exception {
        Histogram[] histograms = new Histogram[threadCount];
        for (int i = 0; i < histograms.length; ++i) {
            histograms[i] = PerfTest.createHistogram();
        }
        int LINES = 262144;
        Thread[] threads = new Thread[threadCount];
        for (int i = 0; i < threads.length; ++i) {
            final Histogram histogram = histograms[i];
            threads[i] = new Thread(){

                @Override
                public void run() {
                    int latencyCount = 5000000;
                    int count = PerfTest.throughput ? 262144 / threadCount : 5000000;
                    MultiThreadPerfTest.this.runTest(runner, count, "end", histogram, threadCount);
                }
            };
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        for (Histogram histogram : histograms) {
            PerfTest.reportResult(resultFile, name, histogram);
        }
    }
}

