/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerContext;
import org.apache.logging.log4j.core.async.BasicAsyncLoggerContextSelector;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class BasicAsyncLoggerContextSelectorTest {
    private static final String FQCN = BasicAsyncLoggerContextSelectorTest.class.getName();

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("Log4jContextSelector", BasicAsyncLoggerContextSelector.class.getName());
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("Log4jContextSelector");
    }

    @Test
    public void testContextReturnsAsyncLoggerContext() {
        BasicAsyncLoggerContextSelector selector = new BasicAsyncLoggerContextSelector();
        LoggerContext context = selector.getContext(FQCN, null, false);
        Assert.assertTrue((boolean)(context instanceof AsyncLoggerContext));
    }

    @Test
    public void testContext2ReturnsAsyncLoggerContext() {
        BasicAsyncLoggerContextSelector selector = new BasicAsyncLoggerContextSelector();
        LoggerContext context = selector.getContext(FQCN, null, false, null);
        Assert.assertTrue((boolean)(context instanceof AsyncLoggerContext));
    }

    @Test
    public void testLoggerContextsReturnsAsyncLoggerContext() {
        BasicAsyncLoggerContextSelector selector = new BasicAsyncLoggerContextSelector();
        List list = selector.getLoggerContexts();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof AsyncLoggerContext));
        selector.getContext(FQCN, null, false);
        list = selector.getLoggerContexts();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof AsyncLoggerContext));
    }

    @Test
    public void testContextNameIsAsyncDefault() {
        BasicAsyncLoggerContextSelector selector = new BasicAsyncLoggerContextSelector();
        LoggerContext context = selector.getContext(FQCN, null, false);
        Assert.assertEquals((Object)"AsyncDefault", (Object)context.getName());
    }

    @Test
    public void testDependentOnClassLoader() {
        BasicAsyncLoggerContextSelector selector = new BasicAsyncLoggerContextSelector();
        Assert.assertFalse((boolean)selector.isClassLoaderDependent());
    }

    @Test
    public void testFactoryIsNotDependentOnClassLoader() {
        Assert.assertFalse((boolean)LogManager.getFactory().isClassLoaderDependent());
    }

    @Test
    public void testLogManagerShutdown() {
        LoggerContext context = (LoggerContext)LogManager.getContext();
        Assert.assertEquals((Object)LifeCycle.State.STARTED, (Object)context.getState());
        LogManager.shutdown();
        Assert.assertEquals((Object)LifeCycle.State.STOPPED, (Object)context.getState());
    }
}

