/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import org.apache.logging.log4j.core.BasicConfigurationFactory;
import org.apache.logging.log4j.core.appender.rolling.action.DeleteAction;
import org.apache.logging.log4j.core.appender.rolling.action.DeletingVisitor;
import org.apache.logging.log4j.core.appender.rolling.action.FixedCondition;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.Configuration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeleteActionTest {
    private static DeleteAction createAnyFilter(String path, boolean followLinks, int maxDepth, boolean testMode) {
        PathCondition[] pathFilters = new PathCondition[]{new FixedCondition(true)};
        return DeleteActionTest.create(path, followLinks, maxDepth, testMode, pathFilters);
    }

    private static DeleteAction create(String path, boolean followLinks, int maxDepth, boolean testMode, PathCondition[] conditions) {
        BasicConfigurationFactory.BasicConfiguration config = new BasicConfigurationFactory.BasicConfiguration(new BasicConfigurationFactory());
        DeleteAction delete = DeleteAction.createDeleteAction((String)path, (boolean)followLinks, (int)maxDepth, (boolean)testMode, null, (PathCondition[])conditions, null, (Configuration)config);
        return delete;
    }

    @Test
    public void testGetBasePathResolvesLookups() {
        DeleteAction delete = DeleteActionTest.createAnyFilter("${sys:user.home}/a/b/c", false, 1, false);
        Path actual = delete.getBasePath();
        String expected = System.getProperty("user.home") + "/a/b/c";
        Assertions.assertEquals((Object)FileSystems.getDefault().getPath(expected, new String[0]), (Object)actual);
    }

    @Test
    public void testGetBasePathStringReturnsOriginalParam() {
        DeleteAction delete = DeleteActionTest.createAnyFilter("${sys:user.home}/a/b/c", false, 1, false);
        Assertions.assertEquals((Object)"${sys:user.home}/a/b/c", (Object)delete.getBasePathString());
    }

    @Test
    public void testGetMaxDepthReturnsConstructorValue() {
        DeleteAction delete = DeleteActionTest.createAnyFilter("any", false, 23, false);
        Assertions.assertEquals((int)23, (int)delete.getMaxDepth());
    }

    @Test
    public void testGetOptionsReturnsEmptySetIfNotFollowingLinks() {
        DeleteAction delete = DeleteActionTest.createAnyFilter("any", false, 0, false);
        Assertions.assertEquals(Collections.emptySet(), (Object)delete.getOptions());
    }

    @Test
    public void testGetOptionsReturnsSetWithFollowLinksIfFollowingLinks() {
        DeleteAction delete = DeleteActionTest.createAnyFilter("any", true, 0, false);
        Assertions.assertEquals(EnumSet.of(FileVisitOption.FOLLOW_LINKS), (Object)delete.getOptions());
    }

    @Test
    public void testGetFiltersReturnsConstructorValue() {
        PathCondition[] filters = new PathCondition[]{new FixedCondition(true), new FixedCondition(false)};
        DeleteAction delete = DeleteActionTest.create("any", true, 0, false, filters);
        Assertions.assertEquals(Arrays.asList(filters), (Object)delete.getPathConditions());
    }

    @Test
    public void testCreateFileVisitorReturnsDeletingVisitor() {
        DeleteAction delete = DeleteActionTest.createAnyFilter("any", true, 0, false);
        FileVisitor visitor = delete.createFileVisitor(delete.getBasePath(), delete.getPathConditions());
        MatcherAssert.assertThat((Object)visitor, (Matcher)Matchers.instanceOf(DeletingVisitor.class));
    }

    @Test
    public void testCreateFileVisitorTestModeIsActionTestMode() {
        DeleteAction delete = DeleteActionTest.createAnyFilter("any", true, 0, false);
        Assertions.assertFalse((boolean)delete.isTestMode());
        FileVisitor visitor = delete.createFileVisitor(delete.getBasePath(), delete.getPathConditions());
        MatcherAssert.assertThat((Object)visitor, (Matcher)Matchers.instanceOf(DeletingVisitor.class));
        Assertions.assertFalse((boolean)((DeletingVisitor)visitor).isTestMode());
        DeleteAction deleteTestMode = DeleteActionTest.createAnyFilter("any", true, 0, true);
        Assertions.assertTrue((boolean)deleteTestMode.isTestMode());
        FileVisitor testVisitor = deleteTestMode.createFileVisitor(delete.getBasePath(), delete.getPathConditions());
        MatcherAssert.assertThat((Object)testVisitor, (Matcher)Matchers.instanceOf(DeletingVisitor.class));
        Assertions.assertTrue((boolean)((DeletingVisitor)testVisitor).isTestMode());
    }
}

