/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.HtmlLayout;
import org.apache.logging.log4j.core.util.IOUtils;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderDirectWriteWithHtmlLayoutTest {
    private static final String DIR = "target/rolling-direct-htmlLayout";
    public static LoggerContextRule loggerContextRule = new LoggerContextRule();
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/rolling-direct-htmlLayout");

    @Test
    public void testRollingFileAppenderWithHtmlLayout() throws Exception {
        this.checkAppenderWithHtmlLayout(true);
    }

    @Test
    public void testRollingFileAppenderWithHtmlLayoutNoAppend() throws Exception {
        this.checkAppenderWithHtmlLayout(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAppenderWithHtmlLayout(boolean append) throws InterruptedException, IOException {
        String prefix = "testHtml_" + (append ? "append_" : "noAppend_");
        Configuration config = loggerContextRule.getConfiguration();
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName("RollingHtml")).withFilePattern("target/rolling-direct-htmlLayout/" + prefix + "_-%d{MM-dd-yy-HH-mm}-%i.html").withPolicy((TriggeringPolicy)new SizeBasedTriggeringPolicy(500L)).withStrategy((RolloverStrategy)DirectWriteRolloverStrategy.newBuilder().withConfig(config).build()).setLayout((Layout)HtmlLayout.createDefaultLayout())).withAppend(append).build();
        boolean stopped = false;
        try {
            int count = 100;
            for (int i = 0; i < count; ++i) {
                appender.append((LogEvent)Log4jLogEvent.newBuilder().setMessage((Message)new SimpleMessage("This is test message number " + i)).build());
            }
            ((RollingFileManager)appender.getManager()).flush();
            appender.stop();
            stopped = true;
            Thread.sleep(50L);
            File dir = new File(DIR);
            Assert.assertTrue((String)"Directory not created", (boolean)dir.exists());
            File[] files = dir.listFiles();
            Assert.assertNotNull((Object)files);
            Assert.assertThat((Object)files, (Matcher)Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".html"))))));
            int foundEvents = 0;
            Pattern eventMatcher = Pattern.compile("title=\"Message\"");
            for (File file : files) {
                if (!file.getName().startsWith(prefix)) continue;
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    String data = IOUtils.toString((Reader)reader).trim();
                    Assert.assertThat((String)("header in file " + file), (Object)data, (Matcher)Matchers.startsWith((String)"<!DOCTYPE"));
                    Assert.assertThat((String)("footer in file " + file), (Object)data, (Matcher)Matchers.endsWith((String)"</html>"));
                    java.util.regex.Matcher matcher = eventMatcher.matcher(data);
                    while (matcher.find()) {
                        ++foundEvents;
                    }
                }
            }
            Assert.assertEquals((String)"Incorrect number of events read.", (long)count, (long)foundEvents);
        }
        finally {
            if (!stopped) {
                appender.stop();
            }
        }
    }
}

