/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.OnStartupTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class OnStartupTriggeringPolicyTest {
    private static final String TARGET_PATTERN = "/test1-%d{MM-dd-yyyy}-%i.log";
    private static final String TEST_DATA = "Hello world!";
    private static final FastDateFormat formatter = FastDateFormat.getInstance((String)"MM-dd-yyyy");
    @TempDir
    Path tempDir;

    @Test
    public void testPolicy() throws Exception {
        long copied;
        DefaultConfiguration configuration = new DefaultConfiguration();
        Path target = this.tempDir.resolve("testfile");
        long timeStamp = Instant.now().minus(Duration.ofDays(1L)).toEpochMilli();
        String expectedDate = formatter.format(timeStamp);
        Path rolled = this.tempDir.resolve("test1-" + expectedDate + "-1.log");
        try (ByteArrayInputStream is = new ByteArrayInputStream(TEST_DATA.getBytes(StandardCharsets.UTF_8));){
            copied = Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
        }
        long size = Files.size(target);
        Assertions.assertTrue((size > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)copied, (long)size);
        FileTime fileTime = FileTime.fromMillis(timeStamp);
        BasicFileAttributeView attrs = Files.getFileAttributeView(target, BasicFileAttributeView.class, new LinkOption[0]);
        attrs.setTimes(fileTime, fileTime, fileTime);
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%msg").withConfiguration((Configuration)configuration).build();
        DefaultRolloverStrategy strategy = DefaultRolloverStrategy.newBuilder().withCompressionLevelStr("0").withStopCustomActionsOnError(true).withConfig((Configuration)configuration).build();
        OnStartupTriggeringPolicy policy = OnStartupTriggeringPolicy.createPolicy((long)1L);
        try (RollingFileManager manager = RollingFileManager.getFileManager((String)target.toString(), (String)(this.tempDir.toString() + TARGET_PATTERN), (boolean)true, (boolean)false, (TriggeringPolicy)policy, (RolloverStrategy)strategy, null, (Layout)layout, (int)8192, (boolean)true, (boolean)false, null, null, null, (Configuration)configuration);){
            String files;
            manager.initialize();
            try (Stream<Path> contents = Files.list(this.tempDir);){
                files = contents.map(Path::toString).collect(Collectors.joining(", ", "[", "]"));
            }
            Assertions.assertTrue((boolean)Files.exists(target, new LinkOption[0]), (String)(target.toString() + ", files = " + files));
            Assertions.assertEquals((long)0L, (long)Files.size(target), (String)target.toString());
            Assertions.assertTrue((boolean)Files.exists(rolled, new LinkOption[0]), (String)("Missing: " + rolled.toString() + ", files on disk = " + files));
            Assertions.assertEquals((long)size, (long)Files.size(rolled), (String)rolled.toString());
        }
    }
}

