/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.kafka;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.log4j.MDC;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.categories.Appenders;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaManager;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.FilteredObjectInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Appenders.Kafka.class})
public class KafkaAppenderTest {
    private static final MockProducer<byte[], byte[]> kafka = new MockProducer<byte[], byte[]>(true, null, null){

        public synchronized Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> record) {
            Future retVal = super.send(record);
            boolean isRetryTest = "true".equals(MDC.get((String)"KafkaAppenderWithRetryCount"));
            if (isRetryTest) {
                try {
                    throw new TimeoutException();
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
            return retVal;
        }

        public void close(long timeout, TimeUnit timeUnit) {
        }
    };
    private static final String LOG_MESSAGE = "Hello, world!";
    private static final String TOPIC_NAME = "kafka-topic";
    private static final int RETRY_COUNT = 3;
    @Rule
    public LoggerContextRule ctx = new LoggerContextRule("KafkaAppenderTest.xml");

    private static Log4jLogEvent createLogEvent() {
        return Log4jLogEvent.newBuilder().setLoggerName(KafkaAppenderTest.class.getName()).setLoggerFqcn(KafkaAppenderTest.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage(LOG_MESSAGE)).build();
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        KafkaManager.producerFactory = config -> kafka;
    }

    @Before
    public void setUp() throws Exception {
        kafka.clear();
    }

    @Test
    public void testAppendWithLayout() throws Exception {
        Appender appender = this.ctx.getRequiredAppender("KafkaAppenderWithLayout");
        appender.append((LogEvent)KafkaAppenderTest.createLogEvent());
        List history = kafka.history();
        Assert.assertEquals((long)1L, (long)history.size());
        ProducerRecord item = (ProducerRecord)history.get(0);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)TOPIC_NAME, (Object)item.topic());
        Assert.assertNull((Object)item.key());
        Assert.assertEquals((Object)"[Hello, world!]", (Object)new String((byte[])item.value(), StandardCharsets.UTF_8));
    }

    @Test
    public void testAppendWithSerializedLayout() throws Exception {
        Appender appender = this.ctx.getRequiredAppender("KafkaAppenderWithSerializedLayout");
        Log4jLogEvent logEvent = KafkaAppenderTest.createLogEvent();
        appender.append((LogEvent)logEvent);
        List history = kafka.history();
        Assert.assertEquals((long)1L, (long)history.size());
        ProducerRecord item = (ProducerRecord)history.get(0);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)TOPIC_NAME, (Object)item.topic());
        Assert.assertNull((Object)item.key());
        Assert.assertEquals((Object)LOG_MESSAGE, (Object)this.deserializeLogEvent((byte[])item.value()).getMessage().getFormattedMessage());
    }

    @Test
    public void testAsyncAppend() throws Exception {
        Appender appender = this.ctx.getRequiredAppender("AsyncKafkaAppender");
        appender.append((LogEvent)KafkaAppenderTest.createLogEvent());
        List history = kafka.history();
        Assert.assertEquals((long)1L, (long)history.size());
        ProducerRecord item = (ProducerRecord)history.get(0);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)TOPIC_NAME, (Object)item.topic());
        Assert.assertNull((Object)item.key());
        Assert.assertEquals((Object)LOG_MESSAGE, (Object)new String((byte[])item.value(), StandardCharsets.UTF_8));
    }

    @Test
    public void testAppendWithKey() throws Exception {
        Appender appender = this.ctx.getRequiredAppender("KafkaAppenderWithKey");
        Log4jLogEvent logEvent = KafkaAppenderTest.createLogEvent();
        appender.append((LogEvent)logEvent);
        List history = kafka.history();
        Assert.assertEquals((long)1L, (long)history.size());
        ProducerRecord item = (ProducerRecord)history.get(0);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)TOPIC_NAME, (Object)item.topic());
        String msgKey = ((byte[])item.key()).toString();
        byte[] keyValue = "key".getBytes(StandardCharsets.UTF_8);
        Assert.assertArrayEquals((byte[])((byte[])item.key()), (byte[])keyValue);
        Assert.assertEquals((Object)LOG_MESSAGE, (Object)new String((byte[])item.value(), StandardCharsets.UTF_8));
    }

    @Test
    public void testAppendWithKeyLookup() throws Exception {
        Appender appender = this.ctx.getRequiredAppender("KafkaAppenderWithKeyLookup");
        Log4jLogEvent logEvent = KafkaAppenderTest.createLogEvent();
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy");
        appender.append((LogEvent)logEvent);
        List history = kafka.history();
        Assert.assertEquals((long)1L, (long)history.size());
        ProducerRecord item = (ProducerRecord)history.get(0);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)TOPIC_NAME, (Object)item.topic());
        byte[] keyValue = format.format(date).getBytes(StandardCharsets.UTF_8);
        Assert.assertArrayEquals((byte[])((byte[])item.key()), (byte[])keyValue);
        Assert.assertEquals((Object)LOG_MESSAGE, (Object)new String((byte[])item.value(), StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendWithRetryCount() {
        try {
            MDC.put((String)"KafkaAppenderWithRetryCount", (Object)"true");
            Appender appender = this.ctx.getRequiredAppender("KafkaAppenderWithRetryCount");
            Log4jLogEvent logEvent = KafkaAppenderTest.createLogEvent();
            appender.append((LogEvent)logEvent);
            List history = kafka.history();
            Assert.assertEquals((long)4L, (long)history.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            MDC.clear();
        }
    }

    private LogEvent deserializeLogEvent(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        try (FilteredObjectInputStream ois = new FilteredObjectInputStream((InputStream)bis);){
            LogEvent logEvent = (LogEvent)ois.readObject();
            return logEvent;
        }
    }
}

