/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.datetime;

import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.core.util.datetime.FastDateParser;
import org.junit.Assert;
import org.junit.Test;

public class FastDateParser_MoreOrLessTest {
    private static final TimeZone NEW_YORK = TimeZone.getTimeZone("America/New_York");

    @Test
    public void testInputHasLessCharacters() {
        FastDateParser parser = new FastDateParser("MM/dd/yyy", TimeZone.getDefault(), Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Assert.assertNull((Object)parser.parse("03/23", parsePosition));
        Assert.assertEquals((long)5L, (long)parsePosition.getErrorIndex());
    }

    @Test
    public void testInputHasMoreCharacters() {
        FastDateParser parser = new FastDateParser("MM/dd", TimeZone.getDefault(), Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = parser.parse("3/23/61", parsePosition);
        Assert.assertEquals((long)4L, (long)parsePosition.getIndex());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Assert.assertEquals((long)2L, (long)calendar.get(2));
        Assert.assertEquals((long)23L, (long)calendar.get(5));
    }

    @Test
    public void testInputHasPrecedingCharacters() {
        FastDateParser parser = new FastDateParser("MM/dd", TimeZone.getDefault(), Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = parser.parse("A 3/23/61", parsePosition);
        Assert.assertNull((Object)date);
        Assert.assertEquals((long)0L, (long)parsePosition.getIndex());
        Assert.assertEquals((long)0L, (long)parsePosition.getErrorIndex());
    }

    @Test
    public void testInputHasWhitespace() {
        FastDateParser parser = new FastDateParser("M/d/y", TimeZone.getDefault(), Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = parser.parse(" 3/ 23/ 1961", parsePosition);
        Assert.assertEquals((long)12L, (long)parsePosition.getIndex());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Assert.assertEquals((long)1961L, (long)calendar.get(1));
        Assert.assertEquals((long)2L, (long)calendar.get(2));
        Assert.assertEquals((long)23L, (long)calendar.get(5));
    }

    @Test
    public void testInputHasWrongCharacters() {
        FastDateParser parser = new FastDateParser("MM-dd-yyy", TimeZone.getDefault(), Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Assert.assertNull((Object)parser.parse("03/23/1961", parsePosition));
        Assert.assertEquals((long)2L, (long)parsePosition.getErrorIndex());
    }

    @Test
    public void testInputHasWrongDay() {
        FastDateParser parser = new FastDateParser("EEEE, MM/dd/yyy", NEW_YORK, Locale.US);
        String input = "Thursday, 03/23/61";
        ParsePosition parsePosition = new ParsePosition(0);
        Assert.assertNotNull((Object)parser.parse("Thursday, 03/23/61", parsePosition));
        Assert.assertEquals((long)"Thursday, 03/23/61".length(), (long)parsePosition.getIndex());
        parsePosition.setIndex(0);
        Assert.assertNull((Object)parser.parse("Thorsday, 03/23/61", parsePosition));
        Assert.assertEquals((long)0L, (long)parsePosition.getErrorIndex());
    }

    @Test
    public void testInputHasWrongTimeZone() {
        FastDateParser parser = new FastDateParser("mm:ss z", NEW_YORK, Locale.US);
        String input = "11:23 Pacific Standard Time";
        ParsePosition parsePosition = new ParsePosition(0);
        Assert.assertNotNull((Object)parser.parse("11:23 Pacific Standard Time", parsePosition));
        Assert.assertEquals((long)"11:23 Pacific Standard Time".length(), (long)parsePosition.getIndex());
        parsePosition.setIndex(0);
        Assert.assertNull((Object)parser.parse("11:23 Pacific Standard ", parsePosition));
        Assert.assertEquals((long)6L, (long)parsePosition.getErrorIndex());
    }
}

