/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.junit.UsingThreadContextMap;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.Strings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-replace.xml")
@UsingThreadContextMap
public class RegexReplacementTest {
    private final ListAppender app;
    private final ListAppender app2;
    private final Logger logger;
    private final Logger logger2;
    private static final String EXPECTED = "/RegexReplacementTest" + Strings.LINE_SEPARATOR;

    public RegexReplacementTest(LoggerContext context, @Named(value="List") ListAppender app, @Named(value="List2") ListAppender app2) {
        this.logger = context.getLogger("LoggerTest");
        this.logger2 = context.getLogger("ReplacementTest");
        this.app = app.clear();
        this.app2 = app2.clear();
    }

    @Test
    public void testReplacement() {
        this.logger.error(this.getClass().getName());
        List<String> msgs = this.app.getMessages();
        Assertions.assertNotNull(msgs);
        Assertions.assertEquals((int)1, (int)msgs.size(), (String)("Incorrect number of messages. Should be 1 is " + msgs.size()));
        Assertions.assertTrue((boolean)msgs.get(0).endsWith(EXPECTED), (String)("Replacement failed - expected ending " + EXPECTED + " Actual " + msgs.get(0)));
        this.app.clear();
        ThreadContext.put((String)"MyKey", (String)"Apache");
        this.logger.error("This is a test for ${ctx:MyKey}");
        msgs = this.app.getMessages();
        Assertions.assertNotNull(msgs);
        Assertions.assertEquals((int)1, (int)msgs.size(), (String)("Incorrect number of messages. Should be 1 is " + msgs.size()));
        Assertions.assertEquals((Object)("LoggerTest This is a test for Apache" + Strings.LINE_SEPARATOR), (Object)msgs.get(0));
    }

    @Test
    public void testConverter() {
        this.logger2.error(this.getClass().getName());
        List<String> msgs = this.app2.getMessages();
        Assertions.assertNotNull(msgs);
        Assertions.assertEquals((int)1, (int)msgs.size(), (String)("Incorrect number of messages. Should be 1 is " + msgs.size()));
        Assertions.assertTrue((boolean)msgs.get(0).endsWith(EXPECTED), (String)("Replacement failed - expected ending " + EXPECTED + " Actual " + msgs.get(0)));
    }
}

