/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.MdcPatternConverter;
import org.apache.logging.log4j.junit.UsingThreadContextMap;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@UsingThreadContextMap
public class MdcPatternConverterTest {
    @BeforeEach
    public void setup() {
        ThreadContext.put((String)"subject", (String)"I");
        ThreadContext.put((String)"verb", (String)"love");
        ThreadContext.put((String)"object", (String)"Log4j");
    }

    @Test
    public void testConverter() {
        SimpleMessage msg = new SimpleMessage("Hello");
        MdcPatternConverter converter = MdcPatternConverter.newInstance(null);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "{object=Log4j, subject=I, verb=love}";
        Assertions.assertEquals((Object)"{object=Log4j, subject=I, verb=love}", (Object)str, (String)("Incorrect result. Expected {object=Log4j, subject=I, verb=love}, actual " + str));
    }

    @Test
    public void testConverterWithExistingData() {
        SimpleMessage msg = new SimpleMessage("Hello");
        MdcPatternConverter converter = MdcPatternConverter.newInstance(null);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        sb.append("prefix ");
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "prefix {object=Log4j, subject=I, verb=love}";
        Assertions.assertEquals((Object)"prefix {object=Log4j, subject=I, verb=love}", (Object)str, (String)("Incorrect result. Expected prefix {object=Log4j, subject=I, verb=love}, actual " + str));
    }

    @Test
    public void testConverterFullEmpty() {
        ThreadContext.clearMap();
        SimpleMessage msg = new SimpleMessage("Hello");
        MdcPatternConverter converter = MdcPatternConverter.newInstance(null);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "{}";
        Assertions.assertEquals((Object)"{}", (Object)str, (String)("Incorrect result. Expected {}, actual " + str));
    }

    @Test
    public void testConverterFullSingle() {
        ThreadContext.clearMap();
        ThreadContext.put((String)"foo", (String)"bar");
        SimpleMessage msg = new SimpleMessage("Hello");
        MdcPatternConverter converter = MdcPatternConverter.newInstance(null);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "{foo=bar}";
        Assertions.assertEquals((Object)"{foo=bar}", (Object)str, (String)("Incorrect result. Expected {foo=bar}, actual " + str));
    }

    @Test
    public void testConverterWithKey() {
        SimpleMessage msg = new SimpleMessage("Hello");
        String[] options = new String[]{"object"};
        MdcPatternConverter converter = MdcPatternConverter.newInstance((String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "Log4j";
        Assertions.assertEquals((Object)"Log4j", (Object)str);
    }

    @Test
    public void testConverterWithKeys() {
        SimpleMessage msg = new SimpleMessage("Hello");
        String[] options = new String[]{"object, subject"};
        MdcPatternConverter converter = MdcPatternConverter.newInstance((String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "{object=Log4j, subject=I}";
        Assertions.assertEquals((Object)"{object=Log4j, subject=I}", (Object)str);
    }

    @Test
    public void testConverterWithKeysAndPrefix() {
        SimpleMessage msg = new SimpleMessage("Hello");
        String[] options = new String[]{"object, subject"};
        MdcPatternConverter converter = MdcPatternConverter.newInstance((String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        sb.append("prefix ");
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "prefix {object=Log4j, subject=I}";
        Assertions.assertEquals((Object)"prefix {object=Log4j, subject=I}", (Object)str);
    }

    @Test
    public void testConverterWithKeysSinglePresent() {
        SimpleMessage msg = new SimpleMessage("Hello");
        String[] options = new String[]{"object, notpresent"};
        MdcPatternConverter converter = MdcPatternConverter.newInstance((String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "{object=Log4j}";
        Assertions.assertEquals((Object)"{object=Log4j}", (Object)str);
    }

    @Test
    public void testConverterWithKeysNonePresent() {
        ThreadContext.clearMap();
        SimpleMessage msg = new SimpleMessage("Hello");
        String[] options = new String[]{"object, subject"};
        MdcPatternConverter converter = MdcPatternConverter.newInstance((String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "{}";
        Assertions.assertEquals((Object)"{}", (Object)str);
    }
}

