/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.test.AvailablePortFinder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="Currently needs better port choosing support")
@LoggerContextSource(value="log4j-socket.xml")
public class SocketTest {
    private static final int SOCKET_PORT = AvailablePortFinder.getNextAvailable();

    @Test
    public void testConnect(LoggerContext context) {
        System.err.println("Initializing logger");
        Logger logger = (Logger)Assertions.assertDoesNotThrow(() -> context.getLogger(this.getClass().getName()));
        Assertions.assertThrows(AppenderLoggingException.class, () -> logger.error("Log #1"));
    }

    private static class TestSocketServer
    implements Callable<InputStream> {
        private ServerSocket server;
        private Socket client;

        private TestSocketServer() {
        }

        @Override
        public InputStream call() throws Exception {
            this.server = new ServerSocket(SOCKET_PORT);
            this.client = this.server.accept();
            return this.client.getInputStream();
        }

        public void close() {
            TestSocketServer.closeQuietly(this.client);
            TestSocketServer.closeQuietly(this.server);
        }

        private static void closeQuietly(ServerSocket socket) {
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private static void closeQuietly(Socket socket) {
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

