/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.validation.validators;

import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.plugins.util.PluginBuilder;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.validation.PluginWithGenericSubclassFoo1Builder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValidatingPluginWithGenericSubclassFoo1BuilderTest {
    private PluginType<PluginWithGenericSubclassFoo1Builder> plugin;
    private Node node;

    @BeforeEach
    public void setUp() throws Exception {
        PluginManager manager = new PluginManager("Test");
        manager.collectPlugins();
        this.plugin = manager.getPluginType("PluginWithGenericSubclassFoo1Builder");
        Assertions.assertNotNull(this.plugin, (String)"Rebuild this module to make sure annotation processing kicks in.");
        this.node = new Node(null, "Validator", this.plugin);
    }

    @Test
    public void testNullDefaultValue() throws Exception {
        PluginWithGenericSubclassFoo1Builder validatingPlugin = (PluginWithGenericSubclassFoo1Builder)new PluginBuilder(this.plugin).withConfiguration((Configuration)new NullConfiguration()).withConfigurationNode(this.node).build();
        Assertions.assertNull((Object)validatingPlugin);
    }

    @Test
    public void testNonNullValue() throws Exception {
        this.node.getAttributes().put("thing", "thing1");
        this.node.getAttributes().put("foo1", "foo1");
        PluginWithGenericSubclassFoo1Builder validatingPlugin = (PluginWithGenericSubclassFoo1Builder)new PluginBuilder(this.plugin).withConfiguration((Configuration)new NullConfiguration()).withConfigurationNode(this.node).build();
        Assertions.assertNotNull((Object)validatingPlugin);
        Assertions.assertEquals((Object)"thing1", (Object)validatingPlugin.getThing());
        Assertions.assertEquals((Object)"foo1", (Object)validatingPlugin.getFoo1());
    }
}

