/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import org.apache.logging.log4j.core.appender.rolling.action.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DurationTest {
    @Test
    public void testParseFailsIfNullText() {
        Assertions.assertThrows(NullPointerException.class, () -> Duration.parse(null));
    }

    @Test
    public void testParseFailsIfInvalidPattern() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Duration.parse((CharSequence)"abc"));
    }

    @Test
    public void testParseFailsIfSectionsOutOfOrder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Duration.parse((CharSequence)"P4DT2M1S3H"));
    }

    @Test
    public void testParseFailsIfTButMissingTime() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Duration.parse((CharSequence)"P1dT"));
    }

    @Test
    public void testParseIsCaseInsensitive() {
        Assertions.assertEquals((Object)"P4DT3H2M1S", (Object)Duration.parse((CharSequence)"p4dt3h2m1s").toString());
    }

    @Test
    public void testParseAllowsOverflows() {
        Assertions.assertEquals((long)70000L, (long)Duration.parse((CharSequence)"PT70S").toMillis());
        Assertions.assertEquals((long)4200000L, (long)Duration.parse((CharSequence)"PT70M").toMillis());
        Assertions.assertEquals((long)90000000L, (long)Duration.parse((CharSequence)"PT25H").toMillis());
    }

    @Test
    public void testToMillis() {
        Assertions.assertEquals((long)0L, (long)Duration.ZERO.toMillis());
        Assertions.assertEquals((long)1000L, (long)Duration.parse((CharSequence)"PT1S").toMillis());
        Assertions.assertEquals((long)120000L, (long)Duration.parse((CharSequence)"PT2M").toMillis());
        Assertions.assertEquals((long)10800000L, (long)Duration.parse((CharSequence)"PT3H").toMillis());
        Assertions.assertEquals((long)345600000L, (long)Duration.parse((CharSequence)"P4D").toMillis());
        long expected = 356521000L;
        Assertions.assertEquals((long)356521000L, (long)Duration.parse((CharSequence)"P4DT3H2M1S").toMillis());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"PT0S", (Object)Duration.ZERO.toString());
        Assertions.assertEquals((Object)"PT1S", (Object)Duration.parse((CharSequence)"PT1S").toString());
        Assertions.assertEquals((Object)"PT2M1S", (Object)Duration.parse((CharSequence)"PT2M1S").toString());
        Assertions.assertEquals((Object)"PT3H2M1S", (Object)Duration.parse((CharSequence)"PT3H2M1S").toString());
        Assertions.assertEquals((Object)"P4DT3H2M1S", (Object)Duration.parse((CharSequence)"P4DT3H2M1S").toString());
    }

    @Test
    public void testPrefixPNotRequired() {
        Assertions.assertEquals((Object)"PT1S", (Object)Duration.parse((CharSequence)"T1S").toString());
        Assertions.assertEquals((Object)"PT2M1S", (Object)Duration.parse((CharSequence)"T2M1S").toString());
        Assertions.assertEquals((Object)"PT3H2M1S", (Object)Duration.parse((CharSequence)"T3H2M1S").toString());
        Assertions.assertEquals((Object)"P4DT3H2M1S", (Object)Duration.parse((CharSequence)"4DT3H2M1S").toString());
    }

    @Test
    public void testInfixTNotRequired() {
        Assertions.assertEquals((Object)"PT1S", (Object)Duration.parse((CharSequence)"P1S").toString());
        Assertions.assertEquals((Object)"PT2M1S", (Object)Duration.parse((CharSequence)"P2M1S").toString());
        Assertions.assertEquals((Object)"PT3H2M1S", (Object)Duration.parse((CharSequence)"P3H2M1S").toString());
        Assertions.assertEquals((Object)"P4DT3H2M1S", (Object)Duration.parse((CharSequence)"P4D3H2M1S").toString());
    }

    @Test
    public void testPrefixPAndInfixTNotRequired() {
        Assertions.assertEquals((Object)"PT1S", (Object)Duration.parse((CharSequence)"1S").toString());
        Assertions.assertEquals((Object)"PT2M1S", (Object)Duration.parse((CharSequence)"2M1S").toString());
        Assertions.assertEquals((Object)"PT3H2M1S", (Object)Duration.parse((CharSequence)"3H2M1S").toString());
        Assertions.assertEquals((Object)"P4DT3H2M1S", (Object)Duration.parse((CharSequence)"4D3H2M1S").toString());
    }

    @Test
    public void testCompareTo() {
        Assertions.assertEquals((int)-1, (int)Duration.parse((CharSequence)"PT1S").compareTo(Duration.parse((CharSequence)"PT2S")));
        Assertions.assertEquals((int)-1, (int)Duration.parse((CharSequence)"PT1M").compareTo(Duration.parse((CharSequence)"PT2M")));
        Assertions.assertEquals((int)-1, (int)Duration.parse((CharSequence)"PT1H").compareTo(Duration.parse((CharSequence)"PT2H")));
        Assertions.assertEquals((int)-1, (int)Duration.parse((CharSequence)"P1D").compareTo(Duration.parse((CharSequence)"P2D")));
        Assertions.assertEquals((int)0, (int)Duration.parse((CharSequence)"PT1S").compareTo(Duration.parse((CharSequence)"PT1S")));
        Assertions.assertEquals((int)0, (int)Duration.parse((CharSequence)"PT1M").compareTo(Duration.parse((CharSequence)"PT1M")));
        Assertions.assertEquals((int)0, (int)Duration.parse((CharSequence)"PT1H").compareTo(Duration.parse((CharSequence)"PT1H")));
        Assertions.assertEquals((int)0, (int)Duration.parse((CharSequence)"P1D").compareTo(Duration.parse((CharSequence)"P1D")));
        Assertions.assertEquals((int)1, (int)Duration.parse((CharSequence)"PT2S").compareTo(Duration.parse((CharSequence)"PT1S")));
        Assertions.assertEquals((int)1, (int)Duration.parse((CharSequence)"PT2M").compareTo(Duration.parse((CharSequence)"PT1M")));
        Assertions.assertEquals((int)1, (int)Duration.parse((CharSequence)"PT2H").compareTo(Duration.parse((CharSequence)"PT1H")));
        Assertions.assertEquals((int)1, (int)Duration.parse((CharSequence)"P2D").compareTo(Duration.parse((CharSequence)"P1D")));
        Assertions.assertEquals((int)0, (int)Duration.parse((CharSequence)"PT1M").compareTo(Duration.parse((CharSequence)"PT60S")));
        Assertions.assertEquals((int)0, (int)Duration.parse((CharSequence)"PT1H").compareTo(Duration.parse((CharSequence)"PT60M")));
        Assertions.assertEquals((int)0, (int)Duration.parse((CharSequence)"PT1H").compareTo(Duration.parse((CharSequence)"PT3600S")));
        Assertions.assertEquals((int)0, (int)Duration.parse((CharSequence)"P1D").compareTo(Duration.parse((CharSequence)"PT24H")));
        Assertions.assertEquals((int)0, (int)Duration.parse((CharSequence)"P1D").compareTo(Duration.parse((CharSequence)"PT1440M")));
    }

    @Test
    public void testEquals() {
        Assertions.assertNotEquals((Object)Duration.parse((CharSequence)"PT1S"), (Object)Duration.parse((CharSequence)"PT2S"));
        Assertions.assertNotEquals((Object)Duration.parse((CharSequence)"PT1M"), (Object)Duration.parse((CharSequence)"PT2M"));
        Assertions.assertNotEquals((Object)Duration.parse((CharSequence)"PT1H"), (Object)Duration.parse((CharSequence)"PT2H"));
        Assertions.assertNotEquals((Object)Duration.parse((CharSequence)"P1D"), (Object)Duration.parse((CharSequence)"P2D"));
        Assertions.assertEquals((Object)Duration.parse((CharSequence)"PT1S"), (Object)Duration.parse((CharSequence)"PT1S"));
        Assertions.assertEquals((Object)Duration.parse((CharSequence)"PT1M"), (Object)Duration.parse((CharSequence)"PT1M"));
        Assertions.assertEquals((Object)Duration.parse((CharSequence)"PT1H"), (Object)Duration.parse((CharSequence)"PT1H"));
        Assertions.assertEquals((Object)Duration.parse((CharSequence)"P1D"), (Object)Duration.parse((CharSequence)"P1D"));
        Assertions.assertEquals((Object)Duration.parse((CharSequence)"PT1M"), (Object)Duration.parse((CharSequence)"PT60S"));
        Assertions.assertEquals((Object)Duration.parse((CharSequence)"PT1H"), (Object)Duration.parse((CharSequence)"PT60M"));
        Assertions.assertEquals((Object)Duration.parse((CharSequence)"PT1H"), (Object)Duration.parse((CharSequence)"PT3600S"));
        Assertions.assertEquals((Object)Duration.parse((CharSequence)"P1D"), (Object)Duration.parse((CharSequence)"PT24H"));
        Assertions.assertEquals((Object)Duration.parse((CharSequence)"P1D"), (Object)Duration.parse((CharSequence)"PT1440M"));
    }
}

