/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.logging.log4j.core.appender.rolling.action.CommonsCompressAction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class Bzip2CompressActionTest {
    @Test
    public void testConstructorDisallowsNullSource() {
        Assertions.assertThrows(NullPointerException.class, () -> new CommonsCompressAction("bzip2", null, new File("any"), true));
    }

    @Test
    public void testConstructorDisallowsNullDestination() {
        Assertions.assertThrows(NullPointerException.class, () -> new CommonsCompressAction("bzip2", new File("any"), null, true));
    }

    @Test
    public void testExecuteReturnsFalseIfSourceDoesNotExist() throws IOException {
        File source = new File("any");
        while (source.exists()) {
            source = new File(source.getName() + Math.random());
        }
        boolean actual = CommonsCompressAction.execute((String)"bzip2", (File)source, (File)new File("any2"), (boolean)true);
        Assertions.assertFalse((boolean)actual, (String)"Cannot compress non-existing file");
    }

    @Test
    public void testExecuteCompressesSourceFileToDestinationFile(@TempDir File tempDir) throws IOException {
        String LINE1 = "Here is line 1. Random text: ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n";
        String LINE2 = "Here is line 2. Random text: ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n";
        String LINE3 = "Here is line 3. Random text: ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n";
        File source = new File(tempDir, "compressme");
        try (FileWriter fw = new FileWriter(source, false);){
            fw.write("Here is line 1. Random text: ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n");
            fw.write("Here is line 2. Random text: ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n");
            fw.write("Here is line 3. Random text: ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n");
            fw.flush();
        }
        File destination = new File(tempDir, "compressme.bz2");
        Assertions.assertFalse((boolean)destination.exists(), (String)"Destination should not exist yet");
        boolean actual = CommonsCompressAction.execute((String)"bzip2", (File)source, (File)destination, (boolean)true);
        Assertions.assertTrue((boolean)actual, (String)"Bzip2CompressAction should have succeeded");
        Assertions.assertTrue((boolean)destination.exists(), (String)"Destination should exist after Bzip2CompressAction");
        Assertions.assertFalse((boolean)source.exists(), (String)"Source should have been deleted");
        byte[] bz2 = new byte[]{66, 90, 104, 57, 49, 65, 89, 38, 83, 89, -100, -31, -24, 45, 0, 0, 28, -33, -128, 0, 18, 64, 1, 56, 16, 63, -1, -1, -16, 38, 39, -100, 64, 32, 0, 112, 99, 77, 6, -128, 25, 52, 6, 70, -102, 24, -102, 48, -49, -3, 85, 77, 13, 6, -102, 12, 64, 26, 26, 52, 52, -51, 70, 5, 107, 25, -110, 35, 94, -75, 46, 121, 101, 65, -127, 51, 75, 83, 91, 98, 117, 10, 20, -74, -73, 55, -72, 56, -71, 57, -70, 42, 78, -22, -20, -18, -83, -31, -27, 99, -45, 34, -24, -112, 82, -87, 122, 104, -112, 92, -126, 11, 81, -65, 36, 97, 127, 23, 114, 69, 56, 80, -112, -100, -31, -24, 45};
        Assertions.assertEquals((long)bz2.length, (long)destination.length());
        try (FileInputStream fis = new FileInputStream(destination);){
            byte[] actualBz2 = new byte[bz2.length];
            int n = 0;
            int offset = 0;
            while ((offset += (n = fis.read(actualBz2, offset, actualBz2.length - offset))) < actualBz2.length) {
            }
            Assertions.assertArrayEquals((byte[])bz2, (byte[])actualBz2, (String)"Compressed data corrupt");
        }
        var10_15 = null;
        try (BZip2CompressorInputStream bzin = new BZip2CompressorInputStream((InputStream)new ByteArrayInputStream(bz2));){
            StringBuilder sb = new StringBuilder();
            byte[] buf = new byte[1024];
            int n = 0;
            while ((n = bzin.read(buf, 0, buf.length)) > -1) {
                sb.append(new String(buf, 0, n));
            }
            Assertions.assertEquals((Object)"Here is line 1. Random text: ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\nHere is line 2. Random text: ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\nHere is line 3. Random text: ABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n", (Object)sb.toString());
        }
        catch (Throwable throwable) {
            var10_15 = throwable;
            throw throwable;
        }
    }
}

