/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.appender;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.util.SneakyThrow;

@Plugin(name="FailOnce", category="Core", elementType="appender", printObject=true)
public class FailOnceAppender
extends AbstractAppender {
    private final Supplier<Throwable> throwableSupplier;
    private boolean failed = false;
    private List<LogEvent> events = new ArrayList<LogEvent>();

    private FailOnceAppender(String name, Supplier<Throwable> throwableSupplier) {
        super(name, null, null, false, Property.EMPTY_ARRAY);
        this.throwableSupplier = throwableSupplier;
    }

    public synchronized void append(LogEvent event) {
        if (!this.failed) {
            this.failed = true;
            Throwable throwable = this.throwableSupplier.get();
            SneakyThrow.sneakyThrow((Throwable)throwable);
        }
        this.events.add(event);
    }

    public synchronized boolean isFailed() {
        return this.failed;
    }

    public synchronized List<LogEvent> drainEvents() {
        List<LogEvent> oldEvents = this.events;
        this.events = new ArrayList<LogEvent>();
        return oldEvents;
    }

    @PluginFactory
    public static FailOnceAppender createAppender(@PluginAttribute(value="name") @Required(message="A name for the Appender must be specified") String name, @PluginAttribute(value="throwableClassName") String throwableClassName) {
        Supplier<Throwable> throwableSupplier = FailOnceAppender.createThrowableSupplier(name, throwableClassName);
        return new FailOnceAppender(name, throwableSupplier);
    }

    private static Supplier<Throwable> createThrowableSupplier(String name, String throwableClassName) {
        String message = String.format("failing on purpose for appender '%s'", name);
        if (throwableClassName == null || "LoggingException".equals(throwableClassName)) {
            return () -> new LoggingException(message);
        }
        switch (throwableClassName) {
            case "RuntimeException": {
                return () -> new RuntimeException(message);
            }
            case "Exception": {
                return () -> new Exception(message);
            }
            case "Error": {
                return () -> new Error(message);
            }
            case "Throwable": {
                return () -> new Throwable(message);
            }
        }
        throw new IllegalArgumentException("unknown throwable class name: " + throwableClassName);
    }

    public static enum ThrowableClassName {

        public static final String RUNTIME_EXCEPTION = "RuntimeException";
        public static final String LOGGING_EXCEPTION = "LoggingException";
        public static final String EXCEPTION = "Exception";
        public static final String ERROR = "Error";
        public static final String THROWABLE = "Throwable";
    }
}

