/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.UUID;
import org.apache.logging.log4j.core.util.UuidUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UuidTest {
    private static final int COUNT = 200;
    private static final int THREADS = 10;
    private static final long NUM_100NS_INTERVALS_SINCE_UUID_EPOCH = 122192928000000000L;

    @Test
    public void testTimeBaseUuid() {
        long time;
        UUID uuid = UuidUtil.getTimeBasedUuid();
        long current = System.currentTimeMillis() * 10000L + 122192928000000000L;
        Assertions.assertTrue((current + 10000L - (time = uuid.timestamp()) > 0L ? 1 : 0) != 0, (String)"Incorrect time");
        UUID[] uuids = new UUID[200];
        long start = System.nanoTime();
        for (int i = 0; i < 200; ++i) {
            uuids[i] = UuidUtil.getTimeBasedUuid();
        }
        long elapsed = System.nanoTime() - start;
        System.out.println("Elapsed for 200 UUIDS = " + elapsed + " Average = " + elapsed / 200L + " ns");
        int errors = 0;
        for (int i = 0; i < 200; ++i) {
            for (int j = i + 1; j < 200; ++j) {
                if (!uuids[i].equals(uuids[j])) continue;
                ++errors;
                System.out.println("UUID " + i + " equals UUID " + j);
            }
        }
        Assertions.assertEquals((int)0, (int)errors, (String)(errors + " duplicate UUIDS"));
        int variant = uuid.variant();
        Assertions.assertEquals((int)2, (int)variant, (String)("Incorrect variant. Expected 2 got " + variant));
        int version = uuid.version();
        Assertions.assertEquals((int)1, (int)version, (String)("Incorrect version. Expected 1 got " + version));
        long node = uuid.node();
        Assertions.assertTrue((node != 0L ? 1 : 0) != 0, (String)"Invalid node");
    }

    @Test
    public void testInitialize() {
        UuidUtil.initialize(null);
        for (int i = 0; i < 10; ++i) {
            byte[] mac = new byte[i];
            for (int j = 0; j < i; ++j) {
                mac[j] = (byte)j;
            }
            UuidUtil.initialize((byte[])mac);
        }
    }

    @Test
    public void testThreads() throws Exception {
        int i;
        Thread[] threads = new Thread[10];
        UUID[] uuids = new UUID[2000];
        long[] elapsed = new long[10];
        for (i = 0; i < 10; ++i) {
            threads[i] = new Worker(uuids, elapsed, i, 200);
        }
        for (i = 0; i < 10; ++i) {
            threads[i].start();
        }
        long elapsedTime = 0L;
        for (int i2 = 0; i2 < 10; ++i2) {
            threads[i2].join();
            elapsedTime += elapsed[i2];
        }
        System.out.println("Elapsed for 2000 UUIDS = " + elapsedTime + " Average = " + elapsedTime / 2000L + " ns");
        int errors = 0;
        for (int i3 = 0; i3 < 2000; ++i3) {
            for (int j = i3 + 1; j < 2000; ++j) {
                if (!uuids[i3].equals(uuids[j])) continue;
                ++errors;
                System.out.println("UUID " + i3 + " equals UUID " + j);
            }
        }
        Assertions.assertEquals((int)0, (int)errors, (String)(errors + " duplicate UUIDS"));
    }

    private static class Worker
    extends Thread {
        private final UUID[] uuids;
        private final long[] elapsed;
        private final int index;
        private final int count;

        public Worker(UUID[] uuids, long[] elapsed, int index, int count) {
            this.uuids = uuids;
            this.index = index;
            this.count = count;
            this.elapsed = elapsed;
        }

        @Override
        public void run() {
            int pos = this.index * this.count;
            long start = System.nanoTime();
            for (int i = pos; i < pos + this.count; ++i) {
                this.uuids[i] = UuidUtil.getTimeBasedUuid();
            }
            this.elapsed[this.index] = System.nanoTime() - start;
        }
    }
}

