/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.security.KeyStore;
import org.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;
import org.apache.logging.log4j.core.net.ssl.TestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KeyStoreConfigurationTest {
    @Test
    public void loadEmptyConfigurationDeprecated() {
        Assertions.assertThrows(StoreConfigurationException.class, () -> new KeyStoreConfiguration(null, TestConstants.NULL_PWD, null, null));
    }

    @Test
    public void loadEmptyConfiguration() {
        Assertions.assertThrows(StoreConfigurationException.class, () -> new KeyStoreConfiguration(null, (PasswordProvider)new MemoryPasswordProvider(TestConstants.NULL_PWD), null, null));
    }

    @Test
    public void loadNotEmptyConfigurationDeprecated() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", TestConstants.KEYSTORE_PWD(), "JKS", null);
        KeyStore ks = ksc.getKeyStore();
        Assertions.assertNotNull((Object)ks);
    }

    @Test
    public void loadNotEmptyConfiguration() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.KEYSTORE_PWD()), "JKS", null);
        KeyStore ks = ksc.getKeyStore();
        Assertions.assertNotNull((Object)ks);
    }

    @Test
    public void returnTheSameKeyStoreAfterMultipleLoadsDeprecated() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", TestConstants.KEYSTORE_PWD(), "JKS", null);
        KeyStore ks = ksc.getKeyStore();
        KeyStore ks2 = ksc.getKeyStore();
        Assertions.assertSame((Object)ks, (Object)ks2);
    }

    @Test
    public void returnTheSameKeyStoreAfterMultipleLoads() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.KEYSTORE_PWD()), "JKS", null);
        KeyStore ks = ksc.getKeyStore();
        KeyStore ks2 = ksc.getKeyStore();
        Assertions.assertSame((Object)ks, (Object)ks2);
    }

    @Test
    public void wrongPasswordDeprecated() {
        Assertions.assertThrows(StoreConfigurationException.class, () -> new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", "wrongPassword!", null, null));
    }

    @Test
    public void wrongPassword() {
        Assertions.assertThrows(StoreConfigurationException.class, () -> new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", (PasswordProvider)new MemoryPasswordProvider("wrongPassword!".toCharArray()), null, null));
    }
}

