/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.LevelPatternSelector;
import org.apache.logging.log4j.core.layout.MarkerPatternSelector;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.PatternMatch;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PatternSelectorTest {
    LoggerContext ctx = LoggerContext.getContext();

    @Test
    public void testMarkerPatternSelector() throws Exception {
        PatternMatch[] patterns = new PatternMatch[]{new PatternMatch("FLOW", "%d %-5p [%t]: ====== %C{1}.%M:%L %m ======%n")};
        MarkerPatternSelector selector = MarkerPatternSelector.createSelector((PatternMatch[])patterns, (String)"%d %-5p [%t]: %m%n", (boolean)true, (boolean)true, (Configuration)this.ctx.getConfiguration());
        PatternLayout layout = PatternLayout.newBuilder().withPatternSelector((PatternSelector)selector).withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.layout.PatternSelectorTest$FauxLogger").setMarker(MarkerManager.getMarker((String)"FLOW")).setLevel(Level.TRACE).setIncludeLocation(true).setMessage((Message)new SimpleMessage("entry")).build();
        String result1 = new FauxLogger().formatEvent((LogEvent)event1, (Layout<?>)layout);
        String expectSuffix1 = String.format("====== PatternSelectorTest.testMarkerPatternSelector:53 entry ======%n", new Object[0]);
        Assertions.assertTrue((boolean)result1.endsWith(expectSuffix1), (String)("Unexpected result: " + result1));
        Log4jLogEvent event2 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        String result2 = new String(layout.toByteArray((LogEvent)event2));
        String expectSuffix2 = String.format("Hello, world 1!%n", new Object[0]);
        Assertions.assertTrue((boolean)result2.endsWith(expectSuffix2), (String)("Unexpected result: " + result2));
    }

    @Test
    public void testLevelPatternSelector() throws Exception {
        PatternMatch[] patterns = new PatternMatch[]{new PatternMatch("TRACE", "%d %-5p [%t]: ====== %C{1}.%M:%L %m ======%n")};
        LevelPatternSelector selector = LevelPatternSelector.createSelector((PatternMatch[])patterns, (String)"%d %-5p [%t]: %m%n", (boolean)true, (boolean)true, (Configuration)this.ctx.getConfiguration());
        PatternLayout layout = PatternLayout.newBuilder().withPatternSelector((PatternSelector)selector).withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.layout.PatternSelectorTest$FauxLogger").setLevel(Level.TRACE).setIncludeLocation(true).setMessage((Message)new SimpleMessage("entry")).build();
        String result1 = new FauxLogger().formatEvent((LogEvent)event1, (Layout<?>)layout);
        String expectSuffix1 = String.format("====== PatternSelectorTest.testLevelPatternSelector:78 entry ======%n", new Object[0]);
        Assertions.assertTrue((boolean)result1.endsWith(expectSuffix1), (String)("Unexpected result: " + result1));
        Log4jLogEvent event2 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        String result2 = new String(layout.toByteArray((LogEvent)event2));
        String expectSuffix2 = String.format("Hello, world 1!%n", new Object[0]);
        Assertions.assertTrue((boolean)result2.endsWith(expectSuffix2), (String)("Unexpected result: " + result2));
    }

    public static class FauxLogger {
        public String formatEvent(LogEvent event, Layout<?> layout) {
            return new String(layout.toByteArray(event));
        }
    }
}

