/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import org.apache.commons.csv.CSVFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.layout.CsvParameterLayout;
import org.apache.logging.log4j.core.layout.CsvParameterLayoutTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Csv.class})
public class CsvParameterLayoutAllAsyncTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
        System.setProperty("log4j.configurationFile", "AsyncLoggerTest.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Test
    public void testLayoutDefaultNormal() throws Exception {
        Logger root = (Logger)LogManager.getRootLogger();
        CsvParameterLayoutTest.testLayoutNormalApi(root, CsvParameterLayout.createDefaultLayout(), false);
    }

    @Test
    public void testLayoutDefaultObjectArrayMessage() throws Exception {
        Logger root = (Logger)LogManager.getRootLogger();
        CsvParameterLayoutTest.testLayoutNormalApi(root, CsvParameterLayout.createDefaultLayout(), true);
    }

    @Test
    public void testLayoutTab() throws Exception {
        Logger root = (Logger)LogManager.getRootLogger();
        CsvParameterLayoutTest.testLayoutNormalApi(root, CsvParameterLayout.createLayout((CSVFormat)CSVFormat.TDF), true);
    }
}

