/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReusableLogEventFactoryTest {
    @Test
    public void testCreateEventReturnsDifferentInstanceIfNotReleased() throws Exception {
        ReusableLogEventFactory factory = new ReusableLogEventFactory();
        LogEvent event1 = this.callCreateEvent(factory, "a", Level.DEBUG, (Message)new SimpleMessage("abc"), null);
        LogEvent event2 = this.callCreateEvent(factory, "b", Level.INFO, (Message)new SimpleMessage("xyz"), null);
        Assertions.assertNotSame((Object)event1, (Object)event2);
        ReusableLogEventFactory.release((LogEvent)event1);
        ReusableLogEventFactory.release((LogEvent)event2);
    }

    @Test
    public void testCreateEventReturnsSameInstance() throws Exception {
        ReusableLogEventFactory factory = new ReusableLogEventFactory();
        LogEvent event1 = this.callCreateEvent(factory, "a", Level.DEBUG, (Message)new SimpleMessage("abc"), null);
        ReusableLogEventFactory.release((LogEvent)event1);
        LogEvent event2 = this.callCreateEvent(factory, "b", Level.INFO, (Message)new SimpleMessage("xyz"), null);
        Assertions.assertSame((Object)event1, (Object)event2);
        ReusableLogEventFactory.release((LogEvent)event2);
        LogEvent event3 = this.callCreateEvent(factory, "c", Level.INFO, (Message)new SimpleMessage("123"), null);
        Assertions.assertSame((Object)event2, (Object)event3);
        ReusableLogEventFactory.release((LogEvent)event3);
    }

    @Test
    public void testCreateEventOverwritesFields() throws Exception {
        ReusableLogEventFactory factory = new ReusableLogEventFactory();
        LogEvent event1 = this.callCreateEvent(factory, "a", Level.DEBUG, (Message)new SimpleMessage("abc"), null);
        Assertions.assertEquals((Object)"a", (Object)event1.getLoggerName(), (String)"logger");
        Assertions.assertEquals((Object)Level.DEBUG, (Object)event1.getLevel(), (String)"level");
        Assertions.assertEquals((Object)new SimpleMessage("abc"), (Object)event1.getMessage(), (String)"msg");
        ReusableLogEventFactory.release((LogEvent)event1);
        LogEvent event2 = this.callCreateEvent(factory, "b", Level.INFO, (Message)new SimpleMessage("xyz"), null);
        Assertions.assertSame((Object)event1, (Object)event2);
        Assertions.assertEquals((Object)"b", (Object)event1.getLoggerName(), (String)"logger");
        Assertions.assertEquals((Object)Level.INFO, (Object)event1.getLevel(), (String)"level");
        Assertions.assertEquals((Object)new SimpleMessage("xyz"), (Object)event1.getMessage(), (String)"msg");
        Assertions.assertEquals((Object)"b", (Object)event2.getLoggerName(), (String)"logger");
        Assertions.assertEquals((Object)Level.INFO, (Object)event2.getLevel(), (String)"level");
        Assertions.assertEquals((Object)new SimpleMessage("xyz"), (Object)event2.getMessage(), (String)"msg");
    }

    private LogEvent callCreateEvent(ReusableLogEventFactory factory, String logger, Level level, Message message, Throwable thrown) {
        return factory.createEvent(logger, null, this.getClass().getName(), level, message, null, thrown);
    }

    @Test
    public void testCreateEventReturnsThreadLocalInstance() throws Exception {
        final ReusableLogEventFactory factory = new ReusableLogEventFactory();
        final LogEvent[] event1 = new LogEvent[1];
        final LogEvent[] event2 = new LogEvent[1];
        Thread t1 = new Thread("THREAD 1"){

            @Override
            public void run() {
                event1[0] = ReusableLogEventFactoryTest.this.callCreateEvent(factory, "a", Level.DEBUG, (Message)new SimpleMessage("abc"), null);
            }
        };
        Thread t2 = new Thread("Thread 2"){

            @Override
            public void run() {
                event2[0] = ReusableLogEventFactoryTest.this.callCreateEvent(factory, "b", Level.INFO, (Message)new SimpleMessage("xyz"), null);
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assertions.assertNotNull((Object)event1[0]);
        Assertions.assertNotNull((Object)event2[0]);
        Assertions.assertNotSame((Object)event1[0], (Object)event2[0]);
        Assertions.assertEquals((Object)"a", (Object)event1[0].getLoggerName(), (String)"logger");
        Assertions.assertEquals((Object)Level.DEBUG, (Object)event1[0].getLevel(), (String)"level");
        Assertions.assertEquals((Object)new SimpleMessage("abc"), (Object)event1[0].getMessage(), (String)"msg");
        Assertions.assertEquals((Object)"THREAD 1", (Object)event1[0].getThreadName(), (String)"thread name");
        Assertions.assertEquals((long)t1.getId(), (long)event1[0].getThreadId(), (String)"tid");
        Assertions.assertEquals((Object)"b", (Object)event2[0].getLoggerName(), (String)"logger");
        Assertions.assertEquals((Object)Level.INFO, (Object)event2[0].getLevel(), (String)"level");
        Assertions.assertEquals((Object)new SimpleMessage("xyz"), (Object)event2[0].getMessage(), (String)"msg");
        Assertions.assertEquals((Object)"Thread 2", (Object)event2[0].getThreadName(), (String)"thread name");
        Assertions.assertEquals((long)t2.getId(), (long)event2[0].getThreadId(), (String)"tid");
        ReusableLogEventFactory.release((LogEvent)event1[0]);
        ReusableLogEventFactory.release((LogEvent)event2[0]);
    }

    @Test
    public void testCreateEventInitFieldsProperly() throws Exception {
        ReusableLogEventFactory factory = new ReusableLogEventFactory();
        LogEvent event = this.callCreateEvent(factory, "logger", Level.INFO, (Message)new SimpleMessage("xyz"), null);
        try {
            Assertions.assertNotNull((Object)event.getContextMap());
            Assertions.assertNotNull((Object)event.getContextData());
            Assertions.assertNotNull((Object)event.getContextStack());
        }
        finally {
            ReusableLogEventFactory.release((LogEvent)event);
        }
    }
}

