/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.DynamicThresholdFilter;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.UsingThreadContextMap;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@UsingThreadContextMap
public class DynamicThresholdFilterTest {
    @Test
    public void testFilter() {
        ThreadContext.put((String)"userid", (String)"testuser");
        ThreadContext.put((String)"organization", (String)"apache");
        KeyValuePair[] pairs = new KeyValuePair[]{new KeyValuePair("testuser", "DEBUG"), new KeyValuePair("JohnDoe", "warn")};
        DynamicThresholdFilter filter = DynamicThresholdFilter.createFilter((String)"userid", (KeyValuePair[])pairs, (Level)Level.ERROR, null, null);
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.ERROR, null, null, (Throwable)null));
        ThreadContext.clearMap();
        ThreadContext.put((String)"userid", (String)"JohnDoe");
        ThreadContext.put((String)"organization", (String)"apache");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("Test")).build();
        Assertions.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event));
        event = Log4jLogEvent.newBuilder().setLevel(Level.ERROR).setMessage((Message)new SimpleMessage("Test")).build();
        Assertions.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event));
        ThreadContext.clearMap();
    }

    @Test
    public void testFilterWorksWhenParamsArePassedAsArguments() {
        ThreadContext.put((String)"userid", (String)"testuser");
        ThreadContext.put((String)"organization", (String)"apache");
        KeyValuePair[] pairs = new KeyValuePair[]{new KeyValuePair("testuser", "DEBUG"), new KeyValuePair("JohnDoe", "warn")};
        DynamicThresholdFilter filter = DynamicThresholdFilter.createFilter((String)"userid", (KeyValuePair[])pairs, (Level)Level.ERROR, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL);
        filter.start();
        Assertions.assertTrue((boolean)filter.isStarted());
        Object[] replacements = new Object[]{"one", "two", "three"};
        Assertions.assertSame((Object)Filter.Result.ACCEPT, (Object)filter.filter(null, Level.DEBUG, null, "some test message", replacements));
        Assertions.assertSame((Object)Filter.Result.ACCEPT, (Object)filter.filter(null, Level.DEBUG, null, "some test message", (Object)"one", (Object)"two", (Object)"three"));
        ThreadContext.clearMap();
    }

    @Test
    @LoggerContextSource(value="log4j2-dynamicfilter.xml")
    public void testConfig(Configuration config) {
        Filter filter = config.getFilter();
        Assertions.assertNotNull((Object)filter, (String)"No DynamicThresholdFilter");
        Assertions.assertTrue((boolean)(filter instanceof DynamicThresholdFilter), (String)"Not a DynamicThresholdFilter");
        DynamicThresholdFilter dynamic = (DynamicThresholdFilter)filter;
        String key = dynamic.getKey();
        Assertions.assertNotNull((Object)key, (String)"Key is null");
        Assertions.assertEquals((Object)"loginId", (Object)key, (String)"Incorrect key value");
        Map map = dynamic.getLevelMap();
        Assertions.assertNotNull((Object)map, (String)"Map is null");
        Assertions.assertEquals((int)1, (int)map.size(), (String)"Incorrect number of map elements");
    }
}

