/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LoggerConfigTest {
    private static LoggerConfig createForProperties(Property[] properties) {
        return LoggerConfig.createLogger((boolean)true, (Level)Level.INFO, (String)"name", (String)"false", (AppenderRef[])new AppenderRef[0], (Property[])properties, (Configuration)new NullConfiguration(), null);
    }

    @Test
    public void testPropertiesWithoutSubstitution() {
        Assertions.assertNull((Object)LoggerConfigTest.createForProperties(null).getPropertyList(), (String)"null propertiesList");
        Property[] all = new Property[]{Property.createProperty((String)"key1", (String)"value1"), Property.createProperty((String)"key2", (String)"value2")};
        LoggerConfig loggerConfig = LoggerConfigTest.createForProperties(all);
        List list = loggerConfig.getPropertyList();
        Assertions.assertEquals(new HashSet(list), new HashSet(loggerConfig.getPropertyList()), (String)"map and list contents equal");
        Object[] actualList = new Object[1];
        loggerConfig.setLogEventFactory((loggerName, marker, fqcn, level, data, properties, t) -> {
            actualList[0] = properties;
            return new Log4jLogEvent.Builder().setTimeMillis(System.currentTimeMillis()).build();
        });
        loggerConfig.log("name", "fqcn", null, Level.INFO, (Message)new SimpleMessage("msg"), null);
        Assertions.assertSame((Object)list, (Object)actualList[0], (String)"propertiesList passed in as is if no substitutions required");
    }

    @Test
    public void testPropertiesWithSubstitution() {
        Property[] all = new Property[]{Property.createProperty((String)"key1", (String)"value1-${sys:user.name}"), Property.createProperty((String)"key2", (String)"value2-${sys:user.name}")};
        LoggerConfig loggerConfig = LoggerConfigTest.createForProperties(all);
        List list = loggerConfig.getPropertyList();
        Assertions.assertEquals(new HashSet(list), new HashSet(loggerConfig.getPropertyList()), (String)"map and list contents equal");
        Object[] actualListHolder = new Object[1];
        loggerConfig.setLogEventFactory((loggerName, marker, fqcn, level, data, properties, t) -> {
            actualListHolder[0] = properties;
            return new Log4jLogEvent.Builder().setTimeMillis(System.currentTimeMillis()).build();
        });
        loggerConfig.log("name", "fqcn", null, Level.INFO, (Message)new SimpleMessage("msg"), null);
        Assertions.assertNotSame((Object)list, (Object)actualListHolder[0], (String)"propertiesList with substitutions");
        List actualList = (List)actualListHolder[0];
        for (int i = 0; i < list.size(); ++i) {
            Assertions.assertEquals((Object)((Property)list.get(i)).getName(), (Object)((Property)actualList.get(i)).getName(), (String)("name[" + i + "]"));
            String value = ((Property)list.get(i)).getValue().replace("${sys:user.name}", System.getProperty("user.name"));
            Assertions.assertEquals((Object)value, (Object)((Property)actualList.get(i)).getValue(), (String)("value[" + i + "]"));
        }
    }
}

