/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.GarbageCollectionHelper;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.async.BlockingAppender;
import org.apache.logging.log4j.core.async.QueueFullAbstractTest;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@RunWith(value=BlockJUnit4ClassRunner.class)
@Category(value={AsyncLoggers.class})
public class QueueFullAsyncLoggerTest3
extends QueueFullAbstractTest {
    @Rule
    public LoggerContextRule context = new LoggerContextRule("log4j2-queueFull.xml", AsyncLoggerContextSelector.class);

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.format.msg.async", "true");
        System.setProperty("log4j2.asyncQueueFullPolicy", "discard");
        System.setProperty("AsyncLogger.RingBufferSize", "128");
        System.setProperty("log4j.configurationFile", "log4j2-queueFull.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Before
    public void before() throws Exception {
        this.blockingAppender = this.context.getRequiredAppender("Blocking", BlockingAppender.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=15000L)
    public void discardedMessagesShouldBeGarbageCollected() throws InterruptedException {
        Logger logger = LogManager.getLogger(this.getClass());
        this.blockingAppender.logEvents = null;
        this.blockingAppender.countDownLatch = new CountDownLatch(1);
        int count = 200;
        CountDownLatch garbageCollectionLatch = new CountDownLatch(count);
        for (int i = 0; i < count; ++i) {
            logger.info((Message)new CountdownOnGarbageCollectMessage(garbageCollectionLatch));
        }
        this.blockingAppender.countDownLatch.countDown();
        gcHelper.run();
        try (GarbageCollectionHelper gcHelper = new GarbageCollectionHelper();){
            Assert.assertTrue((String)"Parameter should have been garbage collected", (boolean)garbageCollectionLatch.await(30L, TimeUnit.SECONDS));
        }
    }

    private static final class CountdownOnGarbageCollectMessage
    implements Message {
        private final CountDownLatch latch;

        CountdownOnGarbageCollectMessage(CountDownLatch latch) {
            this.latch = latch;
        }

        public String getFormattedMessage() {
            return "formatted";
        }

        public String getFormat() {
            return null;
        }

        public Object[] getParameters() {
            return new Object[0];
        }

        public Throwable getThrowable() {
            return null;
        }

        protected void finalize() throws Throwable {
            this.latch.countDown();
            super.finalize();
        }
    }
}

