/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerLocationTest {
    @BeforeClass
    public static void beforeClass() {
        File file = new File("target", "AsyncLoggerLocationTest.log");
        file.delete();
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
        System.setProperty("log4j.configurationFile", "AsyncLoggerLocationTest.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Test
    public void testAsyncLogWritesToLog() throws Exception {
        File file = new File("target", "AsyncLoggerLocationTest.log");
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        String msg = "Async logger msg with location";
        log.info("Async logger msg with location");
        CoreLoggerContexts.stopLoggerContext(false, file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        reader.close();
        file.delete();
        Assert.assertNotNull((String)"line1", (Object)line1);
        Assert.assertTrue((String)"line1 correct", (boolean)line1.contains("Async logger msg with location"));
        String location = "testAsyncLogWritesToLog";
        Assert.assertTrue((String)"has location", (boolean)line1.contains("testAsyncLogWritesToLog"));
    }
}

