/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.io.File;
import java.util.List;
import org.apache.logging.log4j.EventLogger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class JsonRoutingAppenderTest {
    private static final String CONFIG = "log4j-routing.json";
    private static final String LOG_FILENAME = "target/rolling1/rollingtest-Unknown.log";
    private final LoggerContextRule loggerContextRule = new LoggerContextRule("log4j-routing.json");
    @Rule
    public RuleChain rules = this.loggerContextRule.withCleanFilesRule("target/rolling1/rollingtest-Unknown.log");

    @Test
    public void routingTest() {
        StructuredDataMessage msg = new StructuredDataMessage("Test", "This is a test", "Service");
        EventLogger.logEvent((StructuredDataMessage)msg);
        List<LogEvent> list = this.loggerContextRule.getListAppender("List").getEvents();
        Assert.assertNotNull((String)"No events generated", list);
        Assert.assertTrue((String)("Incorrect number of events. Expected 1, got " + list.size()), (list.size() == 1 ? 1 : 0) != 0);
        msg = new StructuredDataMessage("Test", "This is a test", "Unknown");
        EventLogger.logEvent((StructuredDataMessage)msg);
        File file = new File(LOG_FILENAME);
        Assert.assertTrue((String)"File was not created", (boolean)file.exists());
    }
}

