/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.File;
import java.io.PrintStream;
import org.apache.logging.log4j.core.appender.rolling.action.FileRenameAction;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileRenameActionTest {
    static File tempDir = new File("./target");

    @AfterEach
    public void cleanup() {
        File file = new File(tempDir, "newFile.log");
        file.delete();
    }

    @Test
    public void testRename1() throws Exception {
        File file = new File(tempDir, "fileRename.log");
        try (PrintStream pos = new PrintStream(file);){
            for (int i = 0; i < 100; ++i) {
                pos.println("This is line " + i);
            }
        }
        File dest = new File(tempDir, "newFile.log");
        FileRenameAction action = new FileRenameAction(file, dest, false);
        action.execute();
        Assertions.assertTrue((boolean)dest.exists(), (String)"Renamed file does not exist");
        Assertions.assertFalse((boolean)file.exists(), (String)"Old file exists");
    }

    @Test
    public void testEmpty() throws Exception {
        File file = new File(tempDir, "fileRename.log");
        PrintStream pos = new PrintStream(file);
        Throwable throwable = null;
        if (pos != null) {
            if (throwable != null) {
                try {
                    pos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                pos.close();
            }
        }
        Assertions.assertTrue((boolean)file.exists(), (String)"File to rename does not exist");
        File dest = new File(tempDir, "newFile.log");
        FileRenameAction action = new FileRenameAction(file, dest, false);
        action.execute();
        Assertions.assertFalse((boolean)dest.exists(), (String)"Renamed file should not exist");
        Assertions.assertFalse((boolean)file.exists(), (String)"Old file still exists");
    }

    @Test
    public void testRenameEmpty() throws Exception {
        File file = new File(tempDir, "fileRename.log");
        PrintStream pos = new PrintStream(file);
        Throwable throwable = null;
        if (pos != null) {
            if (throwable != null) {
                try {
                    pos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                pos.close();
            }
        }
        Assertions.assertTrue((boolean)file.exists(), (String)"File to rename does not exist");
        File dest = new File(tempDir, "newFile.log");
        FileRenameAction action = new FileRenameAction(file, dest, true);
        action.execute();
        Assertions.assertTrue((boolean)dest.exists(), (String)"Renamed file should exist");
        Assertions.assertFalse((boolean)file.exists(), (String)"Old file still exists");
    }

    @Test
    public void testNoParent() throws Exception {
        File file = new File("fileRename.log");
        try (PrintStream pos = new PrintStream(file);){
            for (int i = 0; i < 100; ++i) {
                pos.println("This is line " + i);
            }
        }
        File dest = new File(tempDir, "newFile.log");
        FileRenameAction action = new FileRenameAction(file, dest, false);
        action.execute();
        Assertions.assertTrue((boolean)dest.exists(), (String)"Renamed file does not exist");
        Assertions.assertFalse((boolean)file.exists(), (String)"Old file exists");
    }
}

