/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import org.apache.logging.log4j.core.appender.MemoryMappedFileManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class MemoryMappedFileManagerTest {
    @TempDir
    File tempDir;

    @Test
    public void testRemapAfterInitialMapSizeExceeded() throws IOException {
        int i;
        int mapSize = 64;
        File file = new File(this.tempDir, "memory-mapped-file.bin");
        boolean append = false;
        boolean immediateFlush = false;
        try (MemoryMappedFileManager manager = MemoryMappedFileManager.getFileManager((String)file.getAbsolutePath(), (boolean)false, (boolean)false, (int)64, null, null);){
            for (i = 0; i < 1000; ++i) {
                byte[] msg = ("Message " + i + "\n").getBytes();
                manager.write(msg, 0, msg.length, false);
            }
        }
        var6_6 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            for (i = 0; i < 1000; ++i) {
                Assertions.assertNotNull((Object)line, (String)"line");
                Assertions.assertTrue((boolean)line.contains("Message " + i), (String)"line incorrect");
                line = reader.readLine();
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testAppendDoesNotOverwriteExistingFile() throws IOException {
        File file = new File(this.tempDir, "memory-mapped-file.bin");
        int initialLength = 4096;
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(new byte[4096], 0, 4096);
            fos.flush();
        }
        Assertions.assertEquals((long)4096L, (long)file.length(), (String)"all flushed to disk");
        boolean isAppend = true;
        boolean immediateFlush = false;
        try (MemoryMappedFileManager manager = MemoryMappedFileManager.getFileManager((String)file.getAbsolutePath(), (boolean)true, (boolean)false, (int)0x2000000, null, null);){
            manager.writeBytes(new byte[4096], 0, 4096);
        }
        int expected = 8192;
        Assertions.assertEquals((long)8192L, (long)file.length(), (String)"appended, not overwritten");
    }
}

