/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import com.google.monitoring.runtime.instrumentation.Sampler;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.junit.jupiter.api.Assertions;

public enum GcFreeLoggingTestUtil {


    public static void executeLogging(String configurationFile, Class<?> testClass) throws Exception {
        System.setProperty("log4j2.enable.threadlocals", "true");
        System.setProperty("log4j2.enable.direct.encoders", "true");
        System.setProperty("log4j2.is.webapp", "false");
        System.setProperty("log4j.configurationFile", configurationFile);
        Assertions.assertTrue((boolean)Constants.ENABLE_THREADLOCALS, (String)"Constants.ENABLE_THREADLOCALS");
        Assertions.assertTrue((boolean)Constants.ENABLE_DIRECT_ENCODERS, (String)"Constants.ENABLE_DIRECT_ENCODERS");
        Assertions.assertFalse((boolean)Constants.IS_WEB_APP, (String)"Constants.IS_WEB_APP");
        MyCharSeq myCharSeq = new MyCharSeq();
        Marker testGrandParent = MarkerManager.getMarker((String)"testGrandParent");
        Marker testParent = MarkerManager.getMarker((String)"testParent").setParents(new Marker[]{testGrandParent});
        Marker test = MarkerManager.getMarker((String)"test").setParents(new Marker[]{testParent});
        ThreadContext.put((String)"aKey", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        Logger logger = LogManager.getLogger((String)testClass.getName());
        logger.debug("debug not set");
        logger.fatal(test, "This message is logged to the console");
        logger.error("Sample error message");
        logger.error("Test parameterized message {}", (Object)"param");
        logger.error((Message)new StringMapMessage().with("eventId", "Login"));
        for (int i = 0; i < 256; ++i) {
            logger.debug("ensure all ringbuffer slots have been used once");
        }
        ThreadContext.remove((String)"aKey");
        ThreadContext.remove((String)"key2");
        final String[] exclude = new String[]{"java/util/concurrent/locks/AbstractQueuedSynchronizer$Node", "com/google/monitoring/runtime/instrumentation/Sampler"};
        final AtomicBoolean samplingEnabled = new AtomicBoolean(true);
        Sampler sampler = new Sampler(){

            public void sampleAllocation(int count, String desc, Object newObj, long size) {
                if (!samplingEnabled.get()) {
                    return;
                }
                for (int i = 0; i < exclude.length; ++i) {
                    if (!exclude[i].equals(desc)) continue;
                    return;
                }
                System.err.println("I just allocated the object " + newObj + " of type " + desc + " whose size is " + size);
                if (count != -1) {
                    System.err.println("It's an array of size " + count);
                }
                new RuntimeException().printStackTrace();
            }
        };
        Thread.sleep(500L);
        StringMapMessage mapMessage = (StringMapMessage)new StringMapMessage().with("eventId", "Login");
        AllocationRecorder.addSampler((Sampler)sampler);
        ThreadContext.put((String)"aKey", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        int ITERATIONS = 5;
        for (int i = 0; i < 5; ++i) {
            logger.error((CharSequence)myCharSeq);
            logger.error(MarkerManager.getMarker((String)"test"), (CharSequence)myCharSeq);
            logger.error("Test message");
            logger.error("Test parameterized message {}", (Object)"param");
            logger.error("Test parameterized message {}{}", (Object)"param", (Object)"param2");
            logger.error("Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
            logger.error((Message)mapMessage);
            ThreadContext.remove((String)"aKey");
            ThreadContext.put((String)"aKey", (String)"value1");
        }
        Thread.sleep(50L);
        samplingEnabled.set(false);
        AllocationRecorder.removeSampler((Sampler)sampler);
        Thread.sleep(100L);
    }

    public static void runTest(Class<?> cls) throws Exception {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        String javaagent = "-javaagent:" + GcFreeLoggingTestUtil.agentJar();
        File tempFile = File.createTempFile("allocations", ".txt");
        tempFile.deleteOnExit();
        ProcessBuilder builder = new ProcessBuilder(javaBin, javaagent, "-cp", classpath, cls.getName());
        builder.redirectError(ProcessBuilder.Redirect.to(tempFile));
        builder.redirectOutput(ProcessBuilder.Redirect.to(tempFile));
        Process process = builder.start();
        process.waitFor();
        process.exitValue();
        AtomicInteger lineCounter = new AtomicInteger(0);
        Files.lines(tempFile.toPath(), Charset.defaultCharset()).forEach(line -> {
            line = line.trim();
            int lineNumber = lineCounter.incrementAndGet();
            if (lineNumber == 1) {
                String className = cls.getSimpleName();
                String firstLinePattern = String.format("^FATAL .*\\.%s %s", className, Pattern.quote("[main] value1 {aKey=value1, key2=value2, prop1=value1, prop2=value2} This message is logged to the console"));
                Assertions.assertTrue((boolean)line.matches(firstLinePattern), (String)("pattern mismatch at line 1: " + line));
            } else {
                Assertions.assertFalse((line.contains("allocated") || line.contains("array") ? 1 : 0) != 0, (String)("(allocated|array) pattern matches at line " + lineNumber + ": " + line));
            }
        });
    }

    private static File agentJar() {
        String name = AllocationRecorder.class.getName();
        URL url = AllocationRecorder.class.getResource("/" + name.replace('.', '/').concat(".class"));
        if (url == null) {
            throw new IllegalStateException("Could not find url for " + name);
        }
        String temp = url.toString();
        String path = temp.substring("jar:file:".length(), temp.indexOf(33));
        return new File(path);
    }

    public static class MyCharSeq
    implements CharSequence {
        final String seq = GcFreeLoggingTestUtil.class.toString();

        @Override
        public int length() {
            return this.seq.length();
        }

        @Override
        public char charAt(int index) {
            return this.seq.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.seq.subSequence(start, end);
        }

        @Override
        public String toString() {
            System.err.println("TEMP OBJECT CREATED!");
            throw new IllegalStateException("TEMP OBJECT CREATED!");
        }
    }
}

