/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class NetUtilsTest {
    private static final boolean IS_WINDOWS = PropertiesUtil.getProperties().isOsWindows();

    @Test
    public void testToUriWithoutBackslashes() throws URISyntaxException {
        String config = "file:///path/to/something/on/unix";
        URI uri = NetUtils.toURI((String)"file:///path/to/something/on/unix");
        Assert.assertNotNull((String)"The URI should not be null.", (Object)uri);
        Assert.assertEquals((String)"The URI is not correct.", (Object)"file:///path/to/something/on/unix", (Object)uri.toString());
    }

    @Test
    public void testToUriWindowsWithBackslashes() throws URISyntaxException {
        Assume.assumeTrue((boolean)IS_WINDOWS);
        String config = "file:///D:\\path\\to\\something/on/windows";
        URI uri = NetUtils.toURI((String)"file:///D:\\path\\to\\something/on/windows");
        Assert.assertNotNull((String)"The URI should not be null.", (Object)uri);
        Assert.assertEquals((String)"The URI is not correct.", (Object)"file:///D:/path/to/something/on/windows", (Object)uri.toString());
    }

    @Test
    public void testToUriWindowsAbsolutePath() throws URISyntaxException {
        Assume.assumeTrue((boolean)IS_WINDOWS);
        String config = "D:\\path\\to\\something\\on\\windows";
        URI uri = NetUtils.toURI((String)"D:\\path\\to\\something\\on\\windows");
        Assert.assertNotNull((String)"The URI should not be null.", (Object)uri);
        Assert.assertEquals((String)"The URI is not correct.", (Object)"file:/D:/path/to/something/on/windows", (Object)uri.toString());
    }
}

